/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import com.paypal.android.instrumentation.base.Logging;
import com.paypal.android.instrumentation.base.commons.lang.Action;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.ui.components.ListView;
import com.paypal.android.instrumentation.base.commons.ui.factories.UIComponentFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import com.paypal.android.instrumentation.base.util.StringUtils;
import com.paypal.android.instrumentation.p2pmobile.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ListViewFactory
extends UIComponentFactory {
    public static final String TAG_NAME = "ListView";

    @Override
    public View createComponent(Context context, AttributeSet attrs, DataContext dataContext, CommandContext commandContext) {
        int resourceId;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ListView, 0, 0);
        if (attributes.getIndexCount() == 0) {
            return new android.widget.ListView(context, attrs);
        }
        ListView listView = new ListView(context, attrs);
        if (attributes.hasValue(R.styleable.ListView_dataSource)) {
            this.handlePropertyBinding(dataContext, attributes, listView, R.styleable.ListView_dataSource);
        }
        if (attributes.hasValue(R.styleable.ListView_onItemClicked)) {
            Assert.State.isValid(attributes.hasValue(R.styleable.ListView_dataSource), "Data source is not defined, unable to add onItemClicked handler!!!");
            this.addOnItemClickedHandler(listView, commandContext, attributes.getString(R.styleable.ListView_onItemClicked));
        }
        if (attributes.hasValue(R.styleable.ListView_itemLayout) && (resourceId = attributes.getResourceId(R.styleable.ListView_itemLayout, -1)) > 0) {
            listView.setItemLayout(resourceId);
        }
        if (attributes.hasValue(R.styleable.ListView_selectedItem)) {
            this.handlePropertyBinding(dataContext, attributes, listView, R.styleable.ListView_selectedItem);
        }
        attributes.recycle();
        return listView;
    }

    private void addOnItemClickedHandler(ListView listView, final CommandContext commandContext, String commandType) {
        Method[] declaredMethods;
        for (final Method method : declaredMethods = commandContext.getClass().getMethods()) {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            String name = method.getName();
            if (!StringUtils.isNotEmpty(commandType) || !commandType.equals(name)) continue;
            Action<Void, Object> commandHandler = new Action<Void, Object>(){

                @Override
                public Void invoke(Object data) {
                    try {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length > 0 && parameterTypes[0].isInstance(data)) {
                            method.invoke((Object)commandContext, data);
                        } else {
                            method.invoke((Object)commandContext, new Object[0]);
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logging.e(Logging.LOG_PREFIX, e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        Logging.e(Logging.LOG_PREFIX, e.getMessage());
                    }
                    return null;
                }
            };
            listView.setOnItemClickedAction(commandHandler);
            return;
        }
    }
}

