/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.TextComponent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueFormatter;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.commons.ui.factories.AbstractTextViewFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import com.paypal.android.instrumentation.p2pmobile.R;

public class TextViewFactory
extends AbstractTextViewFactory {
    public static final String TAG_NAME = "TextView";

    @Override
    public View createComponent(Context context, AttributeSet attrs, DataContext dataContext, CommandContext commandContext) {
        String formatter;
        Optional<PropertyValueFormatter> propertyFormatter;
        String commandAttributes;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.TextView);
        if (attributes.getIndexCount() == 0) {
            TextView txt = new TextView(context, attrs);
            this.onAfterCreateComponent((View)txt, attrs);
            return txt;
        }
        com.paypal.android.instrumentation.base.commons.ui.components.TextView txt = new com.paypal.android.instrumentation.base.commons.ui.components.TextView(context, attrs);
        if (attributes.hasValue(R.styleable.TextView_command)) {
            commandAttributes = attributes.getString(R.styleable.TextView_command);
            this.handleCommandBinding(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.TextView_onClick)) {
            commandAttributes = attributes.getString(R.styleable.TextView_onClick);
            this.handleClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.TextView_onLongClick)) {
            commandAttributes = attributes.getString(R.styleable.TextView_onLongClick);
            this.handleLongClickCommand(context, commandAttributes, commandContext, attributes, (View)txt);
        }
        if (attributes.hasValue(R.styleable.TextView_text)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.TextView_text);
        }
        if (attributes.hasValue(R.styleable.TextView_visibility)) {
            this.handlePropertyBinding(dataContext, attributes, txt, R.styleable.TextView_visibility);
        }
        if (attributes.hasValue(R.styleable.TextView_formatter) && (propertyFormatter = dataContext.getPropertyFormatter(formatter = attributes.getString(R.styleable.TextView_formatter))).hasValue()) {
            Assert.Argument.isValid(propertyFormatter.getValue() instanceof StringFormatter, "Invalid PropertyValueFormatter, only StringFormatter is supported!");
            StringFormatter stringFormatter = (StringFormatter)propertyFormatter.getValue();
            int formatterTypeIndex = attributes.getInteger(R.styleable.TextView_formatterType, 1);
            AbstractTextViewFactory.FormatterType type = AbstractTextViewFactory.FormatterType.getFormatterType(formatterTypeIndex);
            this.handleFormatter(txt, stringFormatter, type);
        }
        if (attributes.hasValue(R.styleable.TextView_updatedSourceTrigger)) {
            int triggerIndex = attributes.getInteger(R.styleable.TextView_updatedSourceTrigger, 1);
            txt.setUpdateSourceTrigger(TextComponent.UpdateSourceTrigger.getUpdateSourceTrigger(triggerIndex));
        }
        if (attributes.hasValue(R.styleable.TextView_adjustsFontSizeToFitWidth)) {
            boolean adjustFont = attributes.getBoolean(R.styleable.TextView_adjustsFontSizeToFitWidth, false);
            txt.setAdjustsFontSizeToFitWidth(adjustFont);
        }
        this.onAfterCreateComponent((View)txt, attrs);
        attributes.recycle();
        return txt;
    }

    @Override
    public void onAfterCreateComponent(View view, AttributeSet attrs) {
        super.onAfterCreateComponent(view, attrs);
        if (view instanceof TextView) {
            Context context = view.getContext();
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.TextView);
            this.stylize(context, attrs, attributes, (TextView)view, 16842884, R.attr.typeface);
        }
    }
}

