/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.paypal.android.instrumentation.base.commons.lang.Optional;
import com.paypal.android.instrumentation.base.commons.lang.RegexPredicate;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.annotations.Command;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.annotations.CommandType;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.Binding;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.CommandContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.DataContext;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.binding.UIComponent;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.CommandFactory;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.commands.CommandFactoryMapper;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.Property;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyKeys;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.PropertyValueConverter;
import com.paypal.android.instrumentation.base.commons.ui.factories.IUIComponentFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;
import com.paypal.android.instrumentation.base.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UIComponentFactory
implements IUIComponentFactory {
    @Override
    public void onAfterCreateComponent(View view, AttributeSet attrs) {
    }

    protected void handleCommandBinding(Context context, String commandAttributes, CommandContext commandContext, TypedArray attributes, View view) {
        List<String> commands = this.getBindingCommands(commandAttributes);
        for (String command : commands) {
            this.tryAddCommandHandler(context, commandContext, view, command);
        }
    }

    protected void handleClickCommand(Context context, String commandAttribute, CommandContext commandContext, TypedArray attributes, View view) {
        this.tryAddCommandHandler(context, commandContext, view, commandAttribute, CommandType.CLICK);
    }

    protected void handleLongClickCommand(Context context, String commandAttribute, CommandContext commandContext, TypedArray attributes, View view) {
        this.tryAddCommandHandler(context, commandContext, view, commandAttribute, CommandType.LONG_CLICK);
    }

    protected void handlePropertyBinding(DataContext dataContext, TypedArray attributes, UIComponent component, int bindingAttribute) {
        String attribute = attributes.getString(bindingAttribute);
        boolean validBinding = this.isProperyValid(attribute);
        Assert.Argument.isValid(validBinding, "Invalid binding attribute!" + attribute);
        String property = this.getProperty(attribute);
        String converter = this.getConverter(attribute);
        this.setupBinding(dataContext, component, property, converter, bindingAttribute);
    }

    protected String getConverter(String attribute) {
        Pattern converterPattern = Pattern.compile("(?<=converter/)\\w+");
        Matcher m = converterPattern.matcher(attribute);
        if (m.find()) {
            return m.group(0);
        }
        return "";
    }

    protected String getProperty(String attribute) {
        Pattern converterPattern = Pattern.compile("(?<=\\{@binding/)\\w+");
        Matcher m = converterPattern.matcher(attribute);
        if (m.find()) {
            return m.group(0);
        }
        return "";
    }

    protected void setupBinding(DataContext dataContext, UIComponent component, String propertyID, String converter, int bindingAttribute) {
        List<Property> properties = dataContext.getProperties();
        Optional<PropertyKeys> optPropertyKey = this.getPropertyKey(propertyID, properties);
        Assert.Argument.isValid("propertyID", propertyID, optPropertyKey.hasValue());
        Optional propertyConverter = TextUtils.isEmpty((CharSequence)converter) ? Optional.absent() : dataContext.getPropertyConverter(converter);
        PropertyKeys property = optPropertyKey.getValue();
        Binding binding = propertyConverter.hasValue() ? new Binding(property, dataContext, component, (PropertyValueConverter)propertyConverter.getValue()) : new Binding(property, dataContext, component);
        component.addBinding(bindingAttribute, binding);
    }

    private Optional<PropertyKeys> getPropertyKey(String propID, List<Property> properties) {
        for (Property property : properties) {
            if (!property.name().equals(propID)) continue;
            Property key = property;
            return Optional.of(key);
        }
        return Optional.absent();
    }

    protected void tryAddCommandHandler(Context context, CommandContext dataContext, View view, String commandName) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = dataContext.getClass().getMethods()) {
            Command command;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!method.isAnnotationPresent(Command.class) || !(command = method.getAnnotation(Command.class)).name().equals(commandName)) continue;
            CommandType type = command.type();
            Optional<? extends CommandFactory> optFactory = CommandFactoryMapper.getFactory(type);
            Assert.State.isValid(optFactory.hasValue(), "Invalid Command!");
            CommandFactory factory = optFactory.getValue();
            factory.handleCommand(dataContext, view, method);
        }
    }

    protected void tryAddCommandHandler(Context context, CommandContext commandContext, View view, String commandName, CommandType commandType) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = commandContext.getClass().getMethods()) {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            String name = method.getName();
            if (!StringUtils.isNotEmpty(commandName) || !commandName.equals(name)) continue;
            Optional<? extends CommandFactory> optFactory = CommandFactoryMapper.getFactory(commandType);
            Assert.State.isValid(optFactory.hasValue(), "Invalid Command!");
            CommandFactory factory = optFactory.getValue();
            factory.handleCommand(commandContext, view, method);
        }
    }

    protected List<String> getBindingCommands(String attributes) {
        boolean validBinding = this.isCommandValid(attributes);
        Assert.Argument.isValid(validBinding, "Invalid binding attribute!" + attributes);
        String result = attributes.replace("{@binding/", "");
        result = result.replace("}", "");
        String[] properties = result.split(",");
        ArrayList<String> propertiesList = new ArrayList<String>();
        Collections.addAll(propertiesList, properties);
        return propertiesList;
    }

    private boolean isCommandValid(String command) {
        RegexPredicate predicate = new RegexPredicate("\\{@binding/[A-Za-z,_ ]+\\}");
        return predicate.apply(command);
    }

    private boolean isProperyValid(String property) {
        RegexPredicate predicate = new RegexPredicate("\\{@binding/[A-Za-z_ ]+[,]?[ ]?(\\@converter/[A-Za-z_ ]+)?\\}");
        return predicate.apply(property);
    }
}

