/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.factories;

import android.content.Context;
import com.paypal.android.instrumentation.base.commons.exception.InvalidArgumentException;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.IModel;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.BindingView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.IView;
import com.paypal.android.instrumentation.base.commons.patterns.mvc.view.ViewEventListener;
import com.paypal.android.instrumentation.base.commons.ui.factories.LayoutFactory;
import com.paypal.android.instrumentation.base.commons.validation.Assert;

public class ViewFactory {
    public static final String VIEWCLASS = "viewClass";

    public static <T extends IView> T createView(Class<T> viewClass, ViewEventListener listener, IModel model, Context context) {
        Assert.Argument.isNotNull(VIEWCLASS, viewClass);
        Assert.Argument.isNotNull("listener", listener);
        Assert.Argument.isNotNull("model", model);
        Assert.Argument.isNotNull("context", context);
        T view = ViewFactory.tryCreateView(viewClass);
        ViewFactory.hookupMVC(view, listener, model, context);
        return view;
    }

    public static <T extends IView> T createView(Class<T> viewClass, ViewEventListener listener, IModel model, Context context, LayoutFactory layoutFactory) {
        Assert.Argument.isNotNull(VIEWCLASS, viewClass);
        Assert.Argument.isNotNull("listener", listener);
        Assert.Argument.isNotNull("model", model);
        Assert.Argument.isNotNull("context", context);
        Assert.Argument.isNotNull("layoutFactory", layoutFactory);
        T view = ViewFactory.tryCreateView(viewClass);
        ViewFactory.hookupMVC(view, listener, model, layoutFactory, context);
        return view;
    }

    public static <T extends BindingView> T createView(Class<T> viewClass) {
        Assert.Argument.isNotNull(VIEWCLASS, viewClass);
        T view = ViewFactory.tryCreateView(viewClass);
        return (T)((BindingView)view);
    }

    private static <T extends IView> T tryCreateView(Class<T> viewClass) {
        try {
            return (T)((IView)viewClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new InvalidArgumentException(VIEWCLASS, "Unable to create new view object", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidArgumentException(VIEWCLASS, "Unable to create new view object", e);
        }
    }

    public static void hookupMVC(IView view, ViewEventListener listener, IModel model, Context context) {
        view.setViewListener(listener);
        view.setModel(model);
        view.initialize(context);
    }

    private static void hookupMVC(IView view, ViewEventListener listener, IModel model, LayoutFactory factory, Context context) {
        view.setViewListener(listener);
        view.setModel(model);
        view.initialize(context, factory);
    }
}

