/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.util;

import com.paypal.android.instrumentation.base.commons.patterns.mvc.model.StringFormatter;
import com.paypal.android.instrumentation.base.util.Money;
import com.paypal.android.instrumentation.base.util.StringUtils;

public class CurrencyFormatter
implements StringFormatter {
    String _currencyCode;
    int _maxDigits;
    String _current;

    public CurrencyFormatter(String currencyCode, int maxDigits) {
        this._currencyCode = currencyCode;
        this._maxDigits = maxDigits;
        this._current = "";
    }

    @Override
    public String format(String value) {
        String sParsedOnlyDigits = value.replaceAll("\\D", "");
        if (StringUtils.isEmpty(sParsedOnlyDigits)) {
            this._current = Money.formatPlainAmount("0", this._currencyCode);
        } else if (sParsedOnlyDigits.length() <= this._maxDigits) {
            this._current = Money.formatPlainAmount(sParsedOnlyDigits, this._currencyCode);
        }
        return this._current;
    }

    @Override
    public void onFormatComplete(String formattedValue) {
    }
}

