/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.ui.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;
import com.paypal.android.instrumentation.base.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class TypefaceUtil {
    private static final Map<String, Typeface> s_loadedTypeface = new HashMap<String, Typeface>();

    public static String getTypefaceFromView(Context context, AttributeSet attrs, int attributeId) {
        String attributeName;
        if (attributeId == -1 || attrs == null) {
            return null;
        }
        try {
            attributeName = context.getResources().getResourceEntryName(attributeId);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        int stringResourceId = attrs.getAttributeResourceValue(null, attributeName, -1);
        return stringResourceId > 0 ? context.getString(stringResourceId) : attrs.getAttributeValue(null, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTypefaceFromTheme(Context context, int styleAttributeId, int attributeId) {
        if (attributeId == -1 || styleAttributeId == -1) {
            return null;
        }
        Resources.Theme theme = context.getTheme();
        TypedValue value = new TypedValue();
        theme.resolveAttribute(styleAttributeId, value, true);
        TypedArray typedArray = theme.obtainStyledAttributes(value.resourceId, new int[]{attributeId});
        try {
            String string = typedArray.getString(0);
            return string;
        }
        catch (Exception ignore) {
            String string = null;
            return string;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTypefaceFromStyle(TypedArray typedArray, int[] attributeId) {
        if (attributeId == null || typedArray == null) {
            return null;
        }
        try {
            String fontFromAttribute = typedArray.getString(0);
            if (!TextUtils.isEmpty((CharSequence)fontFromAttribute)) {
                String string = fontFromAttribute;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            typedArray.recycle();
        }
        return null;
    }

    public static void setTypeface(Context context, TextView txt, String typeface) {
        Typeface typefaceAsset = TypefaceUtil.loadTypeface(context, typeface);
        if (typefaceAsset != null) {
            txt.setTypeface(typefaceAsset);
        }
    }

    private static Typeface loadTypeface(Context context, String fontFamily) {
        if (StringUtils.isEmpty(fontFamily)) {
            return null;
        }
        Typeface typeface = s_loadedTypeface.get(fontFamily);
        if (typeface == null) {
            AssetManager assetManager = context.getAssets();
            try {
                String[] fonts = assetManager.list("fonts");
                if (TypefaceUtil.typefaceExists(fonts, fontFamily)) {
                    typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)String.format("fonts/%s", fontFamily));
                }
            }
            catch (Throwable t) {
                return null;
            }
        }
        if (typeface != null) {
            s_loadedTypeface.put(fontFamily, typeface);
        }
        return typeface;
    }

    private static boolean typefaceExists(String[] fonts, String fontFamily) {
        for (String font : fonts) {
            if (!fontFamily.equals(font)) continue;
            return true;
        }
        return false;
    }
}

