/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.validation;

import com.paypal.android.instrumentation.base.commons.exception.InvalidArgumentException;
import com.paypal.android.instrumentation.base.commons.exception.InvalidStateException;
import com.paypal.android.instrumentation.base.commons.exception.NullArgumentException;

public class Assert {
    public static final String ARGUMENT_NAME = "argumentName";
    public static final String ERROR_MESSAGE = "errorMessage";

    private static class _RecursionSafe {
        private _RecursionSafe() {
        }

        public static class AssertArgument {
            public static void isNotNullNorEmpty(String argumentName, String argumentValue) {
                AssertArgument.isNotNullNorEmpty(argumentName, argumentValue, "Value must not be null nor empty string!");
            }

            public static void isNotNullNorEmpty(String argumentName, String argumentValue, String errorMessage) {
                if (argumentValue == null) {
                    throw new NullArgumentException(argumentName, errorMessage);
                }
                if (AssertArgument.isEmpty(argumentValue)) {
                    throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                }
            }

            public static boolean isNotNullNorEmpty(String argumentValue) {
                return argumentValue != null && AssertArgument.isEmpty(argumentValue);
            }

            public static boolean isEmpty(String argumentValue) {
                return argumentValue.length() == 0;
            }

            public static boolean isNotEmpty(String argumentValue) {
                return argumentValue.length() > 0;
            }
        }
    }

    public static class State {
        public static void isValid(boolean validationResult) {
            State.isValid(validationResult, "Validation failed!");
        }

        public static void isValid(boolean validationResult, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (!validationResult) {
                throw new InvalidStateException(errorMessage);
            }
        }
    }

    public static class Argument {
        public static void isNull(String argumentName, Object argumentValue) {
            Argument.isNull(argumentName, argumentValue, "Value must be null!");
        }

        public static void isNull(String argumentName, Object argumentValue, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (argumentValue != null) {
                throw new NullArgumentException(argumentName, argumentValue, errorMessage);
            }
        }

        public static void isNotNull(String argumentName, Object argumentValue) {
            Argument.isNotNull(argumentName, argumentValue, "Value must not be null!");
        }

        public static void isNotNull(String argumentName, Object argumentValue, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (argumentValue == null) {
                throw new InvalidArgumentException(argumentName, errorMessage);
            }
        }

        public static void isEmpty(String argumentName, String argumentValue) {
            Argument.isEmpty(argumentName, argumentValue, "Value must be empty string!");
        }

        public static void isEmpty(String argumentName, String argumentValue, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            Argument.isNotNull("argumentValue", argumentValue);
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (_RecursionSafe.AssertArgument.isNotEmpty(argumentValue)) {
                throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
            }
        }

        public static void isNotEmpty(String argumentName, String argumentValue) {
            Argument.isNotEmpty(argumentName, argumentValue, "Value must not be empty string!");
        }

        public static void isNotEmpty(String argumentName, String argumentValue, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            Argument.isNotNull("argumentValue", argumentValue);
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (_RecursionSafe.AssertArgument.isEmpty(argumentValue)) {
                throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
            }
        }

        public static void isNullOrEmpty(String argumentName, String argumentValue) {
            Argument.isNullOrEmpty(argumentName, argumentValue, "Value must be null or empty string!");
        }

        public static void isNullOrEmpty(String argumentName, String argumentValue, String errorMessage) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (_RecursionSafe.AssertArgument.isNotNullNorEmpty(argumentValue)) {
                throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
            }
        }

        public static void isNotNullNorEmpty(String argumentName, String argumentValue) {
            Argument.isNotNullNorEmpty(argumentName, argumentValue, "Value must not be null nor empty string!");
        }

        public static void isNotNullNorEmpty(String argumentName, String argumentValue, String errorMessage) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (argumentValue == null) {
                throw new NullArgumentException(argumentName, errorMessage);
            }
            if (_RecursionSafe.AssertArgument.isEmpty(argumentValue)) {
                throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
            }
        }

        public static void isValid(boolean validationResult) {
            Argument.isValid(validationResult, "Validation failed!");
        }

        public static void isValid(boolean validationResult, String errorMessage) {
            Argument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (!validationResult) {
                throw new IllegalArgumentException(errorMessage);
            }
        }

        public static void isValid(String argumentName, Object argumentValue, boolean validationResult) {
            Argument.isValid(argumentName, argumentValue, validationResult, "Validation failed!");
        }

        public static void isValid(String argumentName, Object argumentValue, boolean validationResult, String errorMessage) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ARGUMENT_NAME, argumentName);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Assert.ERROR_MESSAGE, errorMessage);
            if (!validationResult) {
                if (argumentValue == null) {
                    throw new NullArgumentException(argumentName, errorMessage);
                }
                throw new InvalidArgumentException(argumentName, argumentValue, errorMessage);
            }
        }
    }
}

