/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.validation;

import com.paypal.android.instrumentation.base.util.StringUtils;
import java.util.regex.Pattern;

public final class EmailValidator {
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?");

    private EmailValidator() throws IllegalAccessException {
        throw new IllegalAccessException("Do not call utility class constructor");
    }

    public static boolean isEmailValid(String email) {
        if (StringUtils.isEmpty(email)) {
            return false;
        }
        return EMAIL_ADDRESS_PATTERN.matcher(email).matches();
    }
}

