/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.validation;

public class Error {
    private final String _message;
    private final String _formattedMessage;

    public Error(String argumentName, String argumentValue, String errorMessage) {
        this._message = errorMessage;
        this._formattedMessage = this.formatMessage(argumentName, argumentValue, errorMessage);
    }

    public Error(String errorMessage, StackTraceElement[] stackTrace) {
        this._formattedMessage = this.formatMessage(errorMessage, stackTrace);
        this._message = errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    private String formatMessage(String argumentName, String argumentValue, String errorMessage) {
        StringBuilder messageBuilder = new StringBuilder("Error Occurred! - ");
        messageBuilder.append("argumentName - ").append(argumentName);
        messageBuilder.append("\n");
        messageBuilder.append("argumentValue - ").append(argumentValue);
        messageBuilder.append("\n");
        messageBuilder.append("errorMessage - ").append(errorMessage);
        return messageBuilder.toString();
    }

    private String formatMessage(String errorMessage, StackTraceElement[] stackTrace) {
        StringBuilder messageBuilder = new StringBuilder("Error Occurred! - ");
        messageBuilder.append("errorMessage - ").append(errorMessage);
        messageBuilder.append("\n");
        for (StackTraceElement element : stackTrace) {
            messageBuilder.append(element.toString()).append("\n");
        }
        return messageBuilder.toString();
    }

    public String getFormattedMessage() {
        return this._formattedMessage;
    }
}

