/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.commons.validation;

import com.paypal.android.instrumentation.base.commons.exception.InvalidArgumentException;
import com.paypal.android.instrumentation.base.commons.exception.InvalidStateException;
import com.paypal.android.instrumentation.base.commons.exception.NullArgumentException;
import com.paypal.android.instrumentation.base.commons.validation.Error;
import com.paypal.android.instrumentation.base.commons.validation.Errors;

public class Validate {
    public static final String ARGUMENT_NAME = "argumentName";
    public static final String ERROR_MESSAGE = "errorMessage";

    private static <T extends RuntimeException> void formatError(Errors errors, T ex) {
        StackTraceElement[] stackTrace = ex.getStackTrace();
        String message = ex.getMessage();
        Error error = new Error(message, stackTrace);
        errors.putError(error);
    }

    private static class _RecursionSafe {
        private _RecursionSafe() {
        }

        public static class AssertArgument {
            public static void isNotNullNorEmpty(String argumentName, String argumentValue, Errors errors) {
                AssertArgument.isNotNullNorEmpty(argumentName, argumentValue, "Value must not be null nor empty string!", errors);
            }

            public static void isNotNullNorEmpty(String argumentName, String argumentValue, String errorMessage, Errors errors) {
                if (argumentValue == null) {
                    try {
                        throw new NullArgumentException(argumentName, errorMessage);
                    }
                    catch (NullArgumentException ex) {
                        Validate.formatError(errors, ex);
                    }
                }
                if (AssertArgument.isEmpty(argumentValue)) {
                    try {
                        throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                    }
                    catch (InvalidArgumentException ex) {
                        Validate.formatError(errors, ex);
                    }
                }
            }

            public static boolean isNotNullNorEmpty(String argumentValue) {
                return argumentValue != null && AssertArgument.isEmpty(argumentValue);
            }

            public static boolean isEmpty(String argumentValue) {
                return argumentValue.length() == 0;
            }

            public static boolean isNotEmpty(String argumentValue) {
                return argumentValue.length() > 0;
            }
        }
    }

    public static class State {
        public static void isValid(boolean validationResult, Errors errors) {
            State.isValid(validationResult, "Validation failed!", errors);
        }

        public static void isValid(boolean validationResult, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (!validationResult) {
                try {
                    throw new InvalidStateException(errorMessage);
                }
                catch (InvalidStateException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }
    }

    public static class Argument {
        public static void isNull(String argumentName, Object argumentValue, Errors errors) {
            Argument.isNull(argumentName, argumentValue, "Value must be null!", errors);
        }

        public static void isNull(String argumentName, Object argumentValue, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (argumentValue != null) {
                try {
                    throw new NullArgumentException(argumentName, argumentValue, errorMessage);
                }
                catch (NullArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isNotNull(String argumentName, Object argumentValue, Errors errors) {
            Argument.isNotNull(argumentName, argumentValue, "Value must not be null!", errors);
        }

        public static void isNotNull(String argumentName, Object argumentValue, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (argumentValue == null) {
                try {
                    throw new InvalidArgumentException(argumentName, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isEmpty(String argumentName, String argumentValue, Errors errors) {
            Argument.isEmpty(argumentName, argumentValue, "Value must be empty string!", errors);
        }

        public static void isEmpty(String argumentName, String argumentValue, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            Argument.isNotNull("argumentValue", argumentValue, errors);
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (_RecursionSafe.AssertArgument.isNotEmpty(argumentValue)) {
                try {
                    throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isNotEmpty(String argumentName, String argumentValue, Errors errors) {
            Argument.isNotEmpty(argumentName, argumentValue, "Value must not be empty string!", errors);
        }

        public static void isNotEmpty(String argumentName, String argumentValue, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            Argument.isNotNull("argumentValue", argumentValue, errors);
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (_RecursionSafe.AssertArgument.isEmpty(argumentValue)) {
                try {
                    throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isNullOrEmpty(String argumentName, String argumentValue, Errors errors) {
            Argument.isNullOrEmpty(argumentName, argumentValue, "Value must be null or empty string!", errors);
        }

        public static void isNullOrEmpty(String argumentName, String argumentValue, String errorMessage, Errors errors) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (_RecursionSafe.AssertArgument.isNotNullNorEmpty(argumentValue)) {
                try {
                    throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isNotNullNorEmpty(String argumentName, String argumentValue, Errors errors) {
            Argument.isNotNullNorEmpty(argumentName, argumentValue, "Value must not be null nor empty string!", errors);
        }

        public static void isNotNullNorEmpty(String argumentName, String argumentValue, String errorMessage, Errors errors) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (argumentValue == null) {
                try {
                    throw new NullArgumentException(argumentName, errorMessage);
                }
                catch (NullArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
            if (_RecursionSafe.AssertArgument.isEmpty(argumentValue)) {
                try {
                    throw new InvalidArgumentException(argumentName, (Object)argumentValue, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isValid(boolean validationResult, Errors errors) {
            Argument.isValid(validationResult, "Validation failed!", errors);
        }

        public static void isValid(boolean validationResult, String errorMessage, Errors errors) {
            Argument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (!validationResult) {
                try {
                    throw new IllegalArgumentException(errorMessage);
                }
                catch (IllegalArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }

        public static void isValid(String argumentName, Object argumentValue, boolean validationResult, Errors errors) {
            Argument.isValid(argumentName, argumentValue, validationResult, "Validation failed!", errors);
        }

        public static void isValid(String argumentName, Object argumentValue, boolean validationResult, String errorMessage, Errors errors) {
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ARGUMENT_NAME, argumentName, errors);
            _RecursionSafe.AssertArgument.isNotNullNorEmpty(Validate.ERROR_MESSAGE, errorMessage, errors);
            if (!validationResult) {
                if (argumentValue == null) {
                    try {
                        throw new NullArgumentException(argumentName, errorMessage);
                    }
                    catch (NullArgumentException ex) {
                        Validate.formatError(errors, ex);
                    }
                }
                try {
                    throw new InvalidArgumentException(argumentName, argumentValue, errorMessage);
                }
                catch (InvalidArgumentException ex) {
                    Validate.formatError(errors, ex);
                }
            }
        }
    }
}

