/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.domain;

import android.os.Parcel;
import android.os.Parcelable;
import com.paypal.android.instrumentation.base.Core;
import com.paypal.android.instrumentation.base.util.HashCodeUtil;
import java.util.Locale;
import junit.framework.Assert;

public class Country
implements Parcelable {
    private String countryCode;
    public static final Parcelable.Creator<Country> CREATOR = new Parcelable.Creator<Country>(){

        public Country createFromParcel(Parcel in) {
            return new Country(in);
        }

        public Country[] newArray(int size) {
            return new Country[size];
        }
    };

    private Country() {
    }

    public Country(String cc) {
        Assert.assertTrue((String)("Illegal country code <" + cc + ">"), (cc != null && (cc.equals("OTHER") || cc.length() == 2) ? 1 : 0) != 0);
        this.countryCode = cc;
    }

    public Country(Country c) {
        this.countryCode = c.countryCode;
    }

    public String getCode() {
        return this.countryCode;
    }

    public int hashCode() {
        int result = 47;
        result = HashCodeUtil.hash(result, this.countryCode);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Country x = (Country)obj;
        return this.countryCode.equals(x.countryCode);
    }

    public int describeContents() {
        return 0;
    }

    public Country(Parcel in) {
        this.countryCode = in.readString();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.countryCode);
    }

    public String getLocalizedName() {
        return Core.getPerCountryInterface().getLocalizedCountryName(this);
    }

    public Locale getLocale() {
        return Core.getPerCountryInterface().getLocaleForCountry(this);
    }

    public boolean supportsAccountCreation() {
        return Core.getPerCountryInterface().supportsAccountCreation(this);
    }
}

