/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.domain;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import com.paypal.android.instrumentation.base.Core;
import com.paypal.android.instrumentation.base.commons.exception.InvalidArgumentException;
import com.paypal.android.instrumentation.base.domain.Country;
import java.util.Locale;
import java.util.regex.Pattern;

public class PhoneNumber
implements Parcelable {
    private Country mCountry;
    private String mPhoneNumber;
    private static Pattern mPhoneReplace = Pattern.compile("[ .\\-\\(\\)]*");
    private static Pattern mPhoneValid = Pattern.compile("^\\+?[0-9]{7,14}$");
    private static Pattern mPhoneZeroes = Pattern.compile("^\\+?0+$");
    public static final Parcelable.Creator<PhoneNumber> CREATOR = new Parcelable.Creator<PhoneNumber>(){

        public PhoneNumber createFromParcel(Parcel in) {
            return new PhoneNumber(in);
        }

        public PhoneNumber[] newArray(int size) {
            return new PhoneNumber[size];
        }
    };

    public PhoneNumber() {
        Country c = Core.getCurrentCountry();
        String s = Core.getPhonesPhoneNumber(c);
        this.init(c, s);
    }

    public PhoneNumber(Country c, String s) {
        String n = Core.getPerCountryInterface().stripDialingPrefix(c, PhoneNumber.unformatPhoneNumber(s));
        this.init(c, n);
    }

    public PhoneNumber(String c, String n) {
        this.init(new Country(c), n);
    }

    public PhoneNumber(String phoneNum) throws InvalidArgumentException {
        if (phoneNum == null || phoneNum.length() == 0) {
            throw new InvalidArgumentException("phoneNum", "Empty or null string given to PhoneNumber constructor");
        }
        Country c = Core.getCurrentCountry();
        String n = Core.getPerCountryInterface().stripDialingPrefix(c, PhoneNumber.unformatPhoneNumber(phoneNum));
        this.init(c, n);
    }

    private void init(Country c, String s) {
        this.mCountry = c;
        this.mPhoneNumber = s;
    }

    public String getCountryDialingCode() {
        return Core.getPerCountryInterface().getDialingPrefix(this.mCountry);
    }

    public String getNumber() {
        return this.mPhoneNumber;
    }

    public String toPersistedString() {
        return this.mCountry.getCode() + "|" + this.mPhoneNumber;
    }

    public static PhoneNumber fromPersistedString(String s) throws InvalidArgumentException {
        String[] v = s.split("[|]");
        if (v.length != 2) {
            throw new InvalidArgumentException("s", "invalid phonenumber");
        }
        return new PhoneNumber(new Country(v[0]), v[1]);
    }

    public String toString() {
        return this.getNumber();
    }

    public String getFormattedNumber() {
        if (this.mCountry.getLocale().equals(Locale.US)) {
            return PhoneNumberUtils.formatNumber((String)this.mPhoneNumber);
        }
        return this.getNumber();
    }

    public static String cleanPhoneNumber(String phone) {
        String s = mPhoneReplace.matcher(phone).replaceAll("");
        if (s.charAt(0) == '+') {
            return s.substring(1);
        }
        return s;
    }

    public static String unformatPhoneNumber(String phone) {
        return mPhoneReplace.matcher(phone).replaceAll("");
    }

    public static boolean validatePhone(String phone) {
        assert (phone != null);
        return mPhoneValid.matcher(phone = mPhoneReplace.matcher(phone).replaceAll("")).matches() && !mPhoneZeroes.matcher(phone).matches();
    }

    public int describeContents() {
        return 0;
    }

    public PhoneNumber(Parcel in) {
        this.mCountry = (Country)in.readParcelable(Country.class.getClassLoader());
        this.mPhoneNumber = in.readString();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mCountry, 0);
        out.writeString(this.mPhoneNumber);
    }
}

