/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import com.paypal.android.instrumentation.base.Core;
import com.paypal.android.instrumentation.base.util.CurrencyUtil;
import java.math.BigDecimal;
import java.util.Currency;

public class BigDecimalUtils {
    private static Currency _currency;
    private static final Integer PERCENTAGE_PRECISION;

    public static String formatAsString(BigDecimal bd) {
        return BigDecimalUtils.formatAsAmount(bd).toPlainString();
    }

    public static BigDecimal formatAsPercentage(BigDecimal bd) {
        return bd.setScale((int)PERCENTAGE_PRECISION, 4);
    }

    public static BigDecimal formatAsBigDecimal(String d) {
        return BigDecimalUtils.formatAsAmount(new BigDecimal(d));
    }

    public static BigDecimal formatAsAmount(BigDecimal bd) {
        int numberOfDecimals = _currency != null ? CurrencyUtil.getDefaultFractionDigits(_currency.getCurrencyCode()) : CurrencyUtil.getDefaultFractionDigits(Core.getDefaultCurrency().getCurrencyCode());
        return bd.setScale(numberOfDecimals, 4);
    }

    public static BigDecimal makeNotNull(BigDecimal bd) {
        if (bd == null) {
            return BigDecimal.ZERO;
        }
        return bd;
    }

    public static void setCurrency(Currency currency) {
        _currency = currency;
    }

    public static boolean isFirstAmountGreaterThanOrEqual(BigDecimal amountOne, BigDecimal amountTwo) {
        int compareResult = amountOne.compareTo(amountTwo);
        return compareResult == 1 | compareResult == 0;
    }

    public static boolean isFirstAmountBigger(BigDecimal amountOne, BigDecimal amountTwo) {
        return amountOne.compareTo(amountTwo) == 1;
    }

    public static boolean isSecondAmountBigger(BigDecimal amountOne, BigDecimal amountTwo) {
        return amountOne.compareTo(amountTwo) == -1;
    }

    public static boolean areAmountsEquals(BigDecimal amountOne, BigDecimal amountTwo) {
        if (amountOne == null) {
            return amountTwo == null;
        }
        return amountOne.compareTo(amountTwo) == 0;
    }

    public static boolean isEmpty(BigDecimal amount) {
        return amount == null || BigDecimalUtils.areAmountsEquals(amount, BigDecimal.ZERO);
    }

    public static BigDecimal makeNegative(BigDecimal amount) {
        return amount.abs().negate();
    }

    static {
        PERCENTAGE_PRECISION = 3;
    }
}

