/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import com.paypal.android.instrumentation.base.domain.Country;
import com.paypal.android.instrumentation.base.domain.CurrencyComparator;
import com.paypal.android.instrumentation.base.util.PlatformUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Deprecated
public class CurrencyUtil {
    private static NumberFormat currencyFormatter = DecimalFormat.getCurrencyInstance(PlatformUtil.getApplicatonDefaultLocale());
    private static String supportedISO4217Currencies = "AUD, BRL, CAD, CZK, DKK, EUR, HKD, HUF, ILS, JPY, MYR, MXN, NOK, NZD, PHP, PLN, GBP, SGD, SEK, CHF, TWD, THB, USD";
    private static String decimalsNotAllowedStrings = "JPY, HUF, TWD";
    public static final String EUR_CURRENCY = "EUR";
    private static final Locale LOCALE_WITH_PERIOD = Locale.US;
    private static final Locale LOCALE_WITH_COMMA = Locale.GERMANY;
    public static final String CURRENCY_JAPAN = "JPY";
    public static final String CURRENCY_HONGKONG = "HKD";
    private static final DecimalFormat STRIP_TRAILING_ZEROS_DECIMAL_FORMAT = new DecimalFormat("#.##");
    private static final Map<String, Locale> LOCALES = new HashMap<String, Locale>();
    private static List<Currency> supportedCurrencies = null;
    public static final int CURRENCY_SYMBOL_LEFT = 0;
    private static final int CURRENCY_SYMBOL_RIGHT = 1;

    protected static String formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(double amount, String currencyCode, boolean format) {
        return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(amount, currencyCode, format, false);
    }

    protected static String formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(String amountString, String currencyCode, boolean format, boolean isPercent) {
        Double amount = Double.valueOf(amountString);
        if (currencyCode.equals(CURRENCY_HONGKONG)) {
            amount = amount / 10.0;
        }
        return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(amount, currencyCode, format, isPercent);
    }

    private static String formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(double amount, String currencyCode, boolean format, boolean isPercent) {
        boolean symbolIsLeft;
        String symbol;
        String formattedString = "";
        Locale locale = CurrencyUtil.getLocaleFromCurrencyCode(currencyCode);
        if (locale != null) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            symbol = symbols.getCurrencySymbol();
        } else {
            symbol = Currency.getInstance(currencyCode).getSymbol();
        }
        if (!currencyCode.equals(CURRENCY_JAPAN) && !currencyCode.equals(CURRENCY_HONGKONG) || isPercent) {
            amount /= 100.0;
        }
        boolean bl = symbolIsLeft = CurrencyUtil.getCurrencySymbolLocation(currencyCode) == 0;
        if (symbol.equals(currencyCode)) {
            symbol = "";
        }
        formattedString = (symbolIsLeft ? symbol : "") + (format ? CurrencyUtil.formatAmount(amount, currencyCode) : Double.toString(amount)) + (!symbolIsLeft ? symbol : "");
        return formattedString;
    }

    private static String formatAmount(double amount, String currencyCode) {
        String formattedString = null;
        DecimalFormat tempFormatter = CurrencyUtil.getDecimalString(currencyCode).equals(",") ? (DecimalFormat)DecimalFormat.getInstance(LOCALE_WITH_COMMA) : (DecimalFormat)DecimalFormat.getInstance(LOCALE_WITH_PERIOD);
        String numberPattern = "#######0";
        if (CurrencyUtil.decimalsAllowedForCurrency(currencyCode)) {
            numberPattern = currencyCode.equalsIgnoreCase(CURRENCY_HONGKONG) ? "#####0.0" : "#####0.00";
        }
        tempFormatter.applyPattern(numberPattern);
        formattedString = tempFormatter.format(amount);
        return formattedString;
    }

    public static List<Currency> getSupportedCurrencies() {
        if (supportedCurrencies == null) {
            String[] codeStrings;
            supportedCurrencies = new ArrayList<Currency>();
            for (String code : codeStrings = supportedISO4217Currencies.split(",")) {
                supportedCurrencies.add(Currency.getInstance(code.trim()));
            }
            Collections.sort(supportedCurrencies, new CurrencyComparator());
        }
        return supportedCurrencies;
    }

    private static boolean decimalsAllowedForCurrency(String currencyCode) {
        return decimalsNotAllowedStrings.indexOf(currencyCode.toUpperCase()) == -1;
    }

    public static int getCurrencySymbolLocation(String currencyCode) {
        currencyFormatter.setCurrency(Currency.getInstance(currencyCode));
        String sample = currencyFormatter.format(1234.56);
        if (sample.indexOf(49) != 0) {
            return 0;
        }
        return 1;
    }

    private static String getDecimalString(String currencyCode) {
        DecimalFormat temp = new DecimalFormat("0.00");
        temp.setCurrency(Currency.getInstance(currencyCode));
        String sample = temp.format(1.56);
        if (sample.indexOf(46) > 0) {
            return ".";
        }
        return ",";
    }

    public static String getCurrencyCodeForCountry(Country c) {
        return CurrencyUtil.getCurrencyCodeForCountry(c.getCode());
    }

    public static String getCurrencyCodeForCountry(String countryCode) {
        if (countryCode.equalsIgnoreCase("AU")) {
            return "AUD";
        }
        if (countryCode.equalsIgnoreCase("GB")) {
            return "GBP";
        }
        if (countryCode.equalsIgnoreCase("UK")) {
            return "GBP";
        }
        if (countryCode.equalsIgnoreCase("CA")) {
            return "CAD";
        }
        if (countryCode.equalsIgnoreCase("AT")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("CZ")) {
            return "CZK";
        }
        if (countryCode.equalsIgnoreCase("DK")) {
            return "DKK";
        }
        if (countryCode.equalsIgnoreCase("FR")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("DE")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("HU")) {
            return "HUF";
        }
        if (countryCode.equalsIgnoreCase("HK")) {
            return CURRENCY_HONGKONG;
        }
        if (countryCode.equalsIgnoreCase("IE")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("IT")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("NL")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("PL")) {
            return "PLN";
        }
        if (countryCode.equalsIgnoreCase("PT")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("ES")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("SE")) {
            return "SEK";
        }
        if (countryCode.equalsIgnoreCase("ZA")) {
            return "USD";
        }
        if (countryCode.equalsIgnoreCase("NZ")) {
            return "NZD";
        }
        if (countryCode.equalsIgnoreCase("LT")) {
            return EUR_CURRENCY;
        }
        if (countryCode.equalsIgnoreCase("JP")) {
            return CURRENCY_JAPAN;
        }
        return "USD";
    }

    private static Locale getLocaleFromCurrencyCode(String strCode) {
        if (LOCALES.containsKey(strCode)) {
            return LOCALES.get(strCode);
        }
        if (strCode.equalsIgnoreCase("USD")) {
            Locale locale = new Locale("en", "US");
            LOCALES.put(strCode, locale);
            return locale;
        }
        for (Locale locale : NumberFormat.getAvailableLocales()) {
            String code = NumberFormat.getCurrencyInstance(locale).getCurrency().getCurrencyCode();
            if (!strCode.equals(code)) continue;
            LOCALES.put(strCode, locale);
            return locale;
        }
        return null;
    }

    public static String getCurrencySymbol(String currencyCode) {
        Locale locale = CurrencyUtil.getLocaleFromCurrencyCode(currencyCode);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        return symbols.getCurrencySymbol();
    }

    public static int getDefaultFractionDigits(String currencyCode) {
        if (CURRENCY_JAPAN.equals(currencyCode)) {
            return 0;
        }
        if (CURRENCY_HONGKONG.equals(currencyCode)) {
            return 1;
        }
        return 2;
    }

    protected static String formatStripTrailingZeros(BigDecimal value) {
        return STRIP_TRAILING_ZEROS_DECIMAL_FORMAT.format(value);
    }

    @Deprecated
    protected static String toFormattedCurrency(Double value, Locale locale) {
        if (locale.getCountry().equals("JP")) {
            return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_JAPAN, true);
        }
        if (locale.getCountry().equals("HK")) {
            return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_HONGKONG, true);
        }
        NumberFormat format = NumberFormat.getCurrencyInstance(locale);
        return format.format(value);
    }

    protected static String toFormattedCurrency(Double value, Currency currency) {
        if (currency.getCurrencyCode().equals(CURRENCY_JAPAN)) {
            return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_JAPAN, true);
        }
        if (currency.getCurrencyCode().equals(CURRENCY_HONGKONG)) {
            return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_HONGKONG, true);
        }
        NumberFormat format = NumberFormat.getCurrencyInstance(CurrencyUtil.getLocaleFromCurrencyCode(currency.getCurrencyCode()));
        return format.format(value);
    }

    protected static String toFormattedCurrencyNoSymbol(Double value, Currency currency) {
        String formattedCurrencyString;
        if (currency.getCurrencyCode().equals(CURRENCY_JAPAN)) {
            formattedCurrencyString = CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_JAPAN, true);
        } else if (currency.getCurrencyCode().equals(CURRENCY_HONGKONG)) {
            formattedCurrencyString = CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_HONGKONG, true);
        } else {
            NumberFormat format = NumberFormat.getCurrencyInstance(CurrencyUtil.getLocaleFromCurrencyCode(currency.getCurrencyCode()));
            formattedCurrencyString = format.format(value);
        }
        return formattedCurrencyString.replaceAll("[^0-9.]", "");
    }

    protected static String toFormattedCurrencyNoSymbolNoDecimal(Double value, Currency currency) {
        String formattedCurrencyString;
        if (currency.getCurrencyCode().equals(CURRENCY_JAPAN)) {
            formattedCurrencyString = CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_JAPAN, true);
        } else if (currency.getCurrencyCode().equals(CURRENCY_HONGKONG)) {
            formattedCurrencyString = CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(value, CURRENCY_HONGKONG, true);
        } else {
            NumberFormat format = NumberFormat.getCurrencyInstance(CurrencyUtil.getLocaleFromCurrencyCode(currency.getCurrencyCode()));
            formattedCurrencyString = format.format(value / 100.0);
        }
        return formattedCurrencyString.replaceAll("[^0-9.]", "");
    }
}

