/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import com.paypal.android.instrumentation.base.util.BigDecimalUtils;
import com.paypal.android.instrumentation.base.util.CurrencyUtil;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;

public class Money {
    private BigDecimal _amount;
    private Currency _currency;

    public Money(String amount, String currencyCode) {
        this._amount = new BigDecimal(amount);
        this._currency = Currency.getInstance(currencyCode);
    }

    public Money(BigDecimal amount, String currencyCode) {
        this._amount = amount;
        this._currency = Currency.getInstance(currencyCode);
    }

    public Money(BigDecimal amount, Currency currency) {
        this._amount = amount;
        this._currency = currency;
    }

    public String toString() {
        return this.formattedCurrencyAsStringWithSymbol();
    }

    public Currency getCurrency() {
        return this._currency;
    }

    public BigDecimal getAmount() {
        return this._amount;
    }

    public String formattedCurrencyAsStringWithSymbol() {
        return CurrencyUtil.toFormattedCurrency((Double)this._amount.doubleValue(), this._currency);
    }

    public String formattedCurrencyAsStringNoSymbol() {
        return CurrencyUtil.toFormattedCurrencyNoSymbol(this._amount.doubleValue(), this._currency);
    }

    public String formattedCurrencyAsStringNoSymbolNoDecimal() {
        return CurrencyUtil.toFormattedCurrencyNoSymbolNoDecimal(this._amount.doubleValue(), this._currency);
    }

    public static String formatStringRemoveDecimal(String string) {
        return string.replaceAll("[.]", "");
    }

    public static String formatStringRemoveCurrencySymbol(String string) {
        return string.replaceAll("[^0-9.]", "");
    }

    public static String formatSignedStringRemoveCurrencySymbol(String string) {
        return string.replaceAll("[^-0-9.]", "");
    }

    @Deprecated
    public static String formatPlainAmount(String amount, String currencyCode) {
        return Money.formatPlainAmount(amount, currencyCode, true, false);
    }

    @Deprecated
    public static String formatPlainAmount(String amount, String currencyCode, boolean format, boolean isPercent) {
        return CurrencyUtil.formatAmountWithoutDecimalWithCurrencySymbolAndNoSpace(amount, currencyCode, format, isPercent);
    }

    @Deprecated
    public static String toFormattedCurrency(Double value, Locale locale) {
        return CurrencyUtil.toFormattedCurrency(value, locale);
    }

    @Deprecated
    public static String formatStripTrailingZeros(BigDecimal value) {
        return CurrencyUtil.formatStripTrailingZeros(value);
    }

    public boolean isZero() {
        return BigDecimalUtils.areAmountsEquals(this._amount, BigDecimal.ZERO);
    }

    public boolean isPositive() {
        return !this.isZero() && BigDecimalUtils.isFirstAmountBigger(this._amount, BigDecimal.ZERO);
    }

    public boolean isNegative() {
        return !this.isZero() && BigDecimalUtils.isSecondAmountBigger(this._amount, BigDecimal.ZERO);
    }

    public boolean greaterThanOrEqualTo(Money money) {
        return this.equalsAmount(money) || this.greaterThan(money);
    }

    public boolean lessThanOrEqualTo(Money money) {
        return this.equalsAmount(money) || this.lessThan(money);
    }

    public boolean greaterThan(Money money) {
        return BigDecimalUtils.isFirstAmountBigger(this._amount, money._amount);
    }

    public boolean equalsAmount(Money money) {
        return BigDecimalUtils.areAmountsEquals(this._amount, money._amount);
    }

    public boolean lessThan(Money money) {
        return BigDecimalUtils.isSecondAmountBigger(this._amount, money._amount);
    }
}

