/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import android.net.Uri;
import com.paypal.android.instrumentation.base.Logging;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class NetworkUtil {
    private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";

    public static String streamToString(InputStream is, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = NetworkUtil.streamToBytes(is);
        if (bytes == null) {
            return "";
        }
        if (encoding == null) {
            return new String(bytes);
        }
        return new String(bytes, encoding);
    }

    public static byte[] streamToBytes(InputStream is) {
        byte[] byteData = new byte[1024];
        byte[] returnBytes = null;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            int c;
            int totalBytes = 0;
            while ((c = is.read(byteData, 0, byteData.length)) != -1) {
                bytes.write(byteData, 0, c);
                totalBytes += c;
            }
            if (totalBytes > 0) {
                returnBytes = bytes.toByteArray();
            }
            bytes.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnBytes;
    }

    public static String encodeParams(Map<String, String> params) {
        StringBuilder requestBuilder = new StringBuilder();
        for (String property : params.keySet()) {
            try {
                String value = params.get(property);
                String encodedValue = URLEncoder.encode(value, "UTF-8");
                requestBuilder.append(property).append("=").append(encodedValue).append("&");
            }
            catch (UnsupportedEncodingException e) {
                Logging.e(Logging.LOG_PREFIX, e.getMessage());
            }
        }
        return requestBuilder.substring(0, requestBuilder.length() - 1);
    }

    public static Set<String> getQueryParameterNames(Uri uri) {
        int end;
        if (uri.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        String query = uri.getEncodedQuery();
        if (query == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            names.add(Uri.decode((String)name));
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableSet(names);
    }
}

