/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.paypal.android.instrumentation.base.Core;
import com.paypal.android.instrumentation.base.domain.Country;
import com.paypal.android.instrumentation.base.domain.PhoneNumber;
import java.util.Set;

public class SharedPreferenceUtil {
    public static boolean getBooleanPreference(Context c, String key, boolean def) {
        return c.getSharedPreferences(Core.getPrefsFile(), 0).getBoolean(key, def);
    }

    public static void setPreference(Context c, String key, boolean b) {
        SharedPreferences sp = c.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(key, b);
        editor.commit();
    }

    public static String getStringPreference(Context c, String key, String def) {
        return c.getSharedPreferences(Core.getPrefsFile(), 0).getString(key, def);
    }

    public static void setPreference(Context c, String key, String s) {
        SharedPreferences sp = c.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, s);
        editor.commit();
    }

    public static void setPreference(Context c, String key, Set<String> s) {
        SharedPreferences sp = c.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putStringSet(key, s);
        editor.commit();
    }

    public static Set<String> getStringSetPreference(Context c, String key) {
        return c.getSharedPreferences(Core.getPrefsFile(), 0).getStringSet(key, null);
    }

    public static int getIntPreference(Context c, String key, int i) {
        return c.getSharedPreferences(Core.getPrefsFile(), 0).getInt(key, i);
    }

    public static void setPreference(Context c, String key, int num) {
        SharedPreferences sp = c.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(key, num);
        editor.commit();
    }

    public static long getLongPreference(Context c, String key, long i) {
        return c.getSharedPreferences(Core.getPrefsFile(), 0).getLong(key, i);
    }

    public static void setPreference(Context c, String key, long num) {
        SharedPreferences sp = c.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong(key, num);
        editor.commit();
    }

    public static void setPreference(Context c, String key, PhoneNumber pn) {
        if (pn != null) {
            SharedPreferenceUtil.setPreference(c, key, pn.toPersistedString());
        } else {
            SharedPreferenceUtil.setPreference(c, key, "");
        }
    }

    public static void clearPreferenceIfPresent(Context ctx, String key) {
        SharedPreferences sp = ctx.getSharedPreferences(Core.getPrefsFile(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key);
        editor.commit();
    }

    public static void setPreference(Context ctx, String key, Country c) {
        SharedPreferenceUtil.setPreference(ctx, key, c.getCode());
    }

    public static Country getCountryPreference(Context c, String key) {
        String s = c.getSharedPreferences(Core.getPrefsFile(), 0).getString(key, "");
        if (s.length() != 2) {
            return null;
        }
        return new Country(s);
    }
}

