/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static MessageDigest md5;
    private static final String HEXITS = "0123456789abcdef";

    private StringUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Do not call utility class constructor");
    }

    public static String hash(String text) {
        byte[] bytes = text.getBytes();
        md5.update(bytes);
        byte[] hash = md5.digest();
        return StringUtils.toHex(hash);
    }

    private static String toHex(byte[] block) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < block.length; ++i) {
            buf.append(HEXITS.charAt(block[i] >>> 4 & 0xF));
            buf.append(HEXITS.charAt(block[i] & 0xF));
        }
        return buf + "";
    }

    public static String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
            temp.append(decimal);
        }
        return sb.toString();
    }

    public static final byte[] hexStringToByteArray(String hexString, String separator) {
        if (separator == "") {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int lastIndex = 0;
            while (lastIndex + 2 < hexString.length()) {
                bout.write(Integer.parseInt(hexString.substring(lastIndex, lastIndex + 2), 16));
                lastIndex += 2;
            }
            bout.write(Integer.parseInt(hexString.substring(lastIndex), 16));
            return bout.toByteArray();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int index = 0;
        int lastIndex = 0;
        while ((index = hexString.indexOf(separator, index + 1)) != -1) {
            bout.write(Integer.parseInt(hexString.substring(lastIndex, index), 16));
            lastIndex = index + 1;
        }
        bout.write(Integer.parseInt(hexString.substring(lastIndex), 16));
        return bout.toByteArray();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean areEqual(String str1, String str2) {
        return StringUtils.emptyIfNull(str1).equals(StringUtils.emptyIfNull(str2));
    }

    public static String emptyIfNull(String inString) {
        return inString == null ? "" : inString;
    }

    public static String cleanHTML(String text) {
        try {
            if (text != null) {
                String pattern = "\\<.*?\\>";
                return text.replaceAll(pattern, "");
            }
            return text;
        }
        catch (Exception ex) {
            return text;
        }
    }

    public static String encodeParam(String param, String value) {
        if (value == null) {
            return "";
        }
        return "&" + param + "=" + URLEncoder.encode(value);
    }

    public static List<String> intersectStringList(List<String> list1, List<String> list2) {
        ArrayList<String> intersect = new ArrayList<String>();
        for (int i = 0; i < list1.size(); ++i) {
            String s1 = list1.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                if (s1.compareTo(list2.get(j)) != 0) continue;
                intersect.add(s1);
            }
        }
        return intersect;
    }

    public static String join(List<?> array, char separator) {
        if (array.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object item : array) {
            builder.append(item).append(separator);
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    public static boolean hasSpecialCharacters(String str) {
        Pattern p = Pattern.compile("[^a-z0-9]", 2);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isPrefixFor(String prefix, String stringBeingSearched) {
        if (StringUtils.isEmpty(prefix) || StringUtils.isEmpty(stringBeingSearched) || prefix.length() > stringBeingSearched.length()) {
            return false;
        }
        int prefixLength = prefix.length();
        return prefix.equals(stringBeingSearched.substring(0, prefixLength));
    }

    public static String defaultIfEmpty(String input, String defaultValue) {
        return StringUtils.isEmpty(input) ? defaultValue : input;
    }

    public static String defaultIfNotValid(boolean expresion, String input, String defaultValue) {
        return expresion ? input : defaultValue;
    }

    public static String trimIfNotNull(String str) {
        return str != null ? str.trim() : null;
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

