/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.instrumentation.base.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import java.util.ArrayList;
import java.util.List;

public class SystemUtils {
    private SystemUtils() {
    }

    public static void call(String number, Context context) {
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.addFlags(0x10000000);
        intent.setData(Uri.parse((String)("tel:" + number)));
        context.startActivity(intent);
    }

    public static void sendSMS(String number, Context context) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.addFlags(0x10000000);
        intent.setData(Uri.parse((String)("smsto:" + number)));
        context.startActivity(intent);
    }

    private static Intent buildSingleEmailIntent(String subject, String body, List<String> recipients) {
        Uri recipientsUri = SystemUtils.generateRecipientsUri(recipients);
        Intent intent = new Intent("android.intent.action.SENDTO", recipientsUri);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    public static void sendEmail(String subject, String body, String recipient, Context context) {
        ArrayList<String> recipientList = new ArrayList<String>();
        recipientList.add(recipient);
        Intent intent = SystemUtils.buildSingleEmailIntent(subject, body, recipientList);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private static Uri generateRecipientsUri(List<String> recipientList) {
        StringBuilder uriBuilder = new StringBuilder();
        for (String recipient : recipientList) {
            if (recipientList.indexOf(recipient) > 0) {
                uriBuilder.append(",");
            }
            uriBuilder.append(recipient);
        }
        return Uri.fromParts((String)"mailto", (String)uriBuilder.toString(), null);
    }

    public static String getCarrierOrDefault(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String carrier = tm.getNetworkOperatorName();
        if (carrier == null) {
            carrier = "";
        }
        return carrier;
    }

    public static String getReportingVersion(boolean isTablet) {
        return isTablet ? "AndroidTablet" : "Android";
    }

    public static String getResolution(Context context, int formatStringIdRes) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return String.format(context.getResources().getString(formatStringIdRes), metrics.widthPixels, metrics.heightPixels);
    }
}

