/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.manticore;

import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.IManticoreTypeConverter;
import com.paypal.manticore.JsBackedObject;
import com.paypal.manticore.ManticoreEngine;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTypeConverter
implements IManticoreTypeConverter {
    protected ManticoreEngine engine;

    public DefaultTypeConverter(ManticoreEngine engine) {
        this.engine = engine;
    }

    @Override
    public <T> T asNative(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (JsBackedObject.class.isAssignableFrom(type)) {
            JsBackedObject returnValue = null;
            try {
                returnValue = (JsBackedObject)type.getDeclaredMethod("nativeInstanceForObject", V8Object.class).invoke(null, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            returnValue.impl = (V8Object)value;
            return type.cast(returnValue);
        }
        if (type == BigDecimal.class) {
            V8Object jsDecimal = (V8Object)value;
            String stringValue = jsDecimal.executeStringFunction("toString", null);
            return type.cast(new BigDecimal(stringValue));
        }
        if (Exception.class.isAssignableFrom(type)) {
            // empty if block
        }
        return type.cast(value);
    }

    @Override
    public V8Object asJs(Object nativeInstance) {
        if (nativeInstance instanceof JsBackedObject) {
            return ((JsBackedObject)nativeInstance).impl;
        }
        return null;
    }

    @Override
    public String asJsDecimal(BigDecimal d) {
        if (d == null) {
            return null;
        }
        return d.toString();
    }

    @Override
    public BigDecimal asNativeDecimal(V8Object value) {
        return new BigDecimal(value.toString());
    }

    @Override
    public Date asNativeDate(V8Object date) {
        return new Date(Double.valueOf(date.executeDoubleFunction("getTime", this.engine.EmptyArray)).longValue());
    }

    @Override
    public V8Object asJsDate(Date d) {
        if (d == null) {
            return null;
        }
        return this.engine.getManticoreJsObject().executeObjectFunction("newDate", this.engine.createJsArray().push((double)d.getTime()));
    }

    @Override
    public <T> V8Array toJsArray(List<T> nativeList, IManticoreTypeConverter.JsElementConverter<T> converter) {
        if (nativeList == null) {
            return null;
        }
        V8Array jsArray = new V8Array(this.engine.v8);
        for (T element : nativeList) {
            converter.push(jsArray, element);
        }
        return jsArray;
    }

    @Override
    public <T> List<T> toNativeArray(V8Array jsArray, IManticoreTypeConverter.NativeElementConverter<T> converter) {
        if (jsArray == null) {
            return null;
        }
        ArrayList<T> nativeList = new ArrayList<T>();
        for (int i = 0; i < jsArray.length(); ++i) {
            nativeList.add(converter.convert(jsArray.get(i)));
        }
        return nativeList;
    }

    @Override
    public V8Object asJsObject(Map<String, ? super Object> map) {
        if (map == null) {
            return null;
        }
        V8Object dict = new V8Object(this.engine.v8);
        for (Map.Entry<String, ? super Object> kv : map.entrySet()) {
            Object v = kv.getValue();
            if (v == null) {
                dict.addNull(kv.getKey());
                continue;
            }
            if (v instanceof Double) {
                dict.add(kv.getKey(), ((Double)v).doubleValue());
                continue;
            }
            if (v instanceof Integer) {
                dict.add(kv.getKey(), ((Integer)v).intValue());
                continue;
            }
            if (v instanceof Boolean) {
                dict.add(kv.getKey(), ((Boolean)v).booleanValue());
                continue;
            }
            if (v instanceof String) {
                dict.add(kv.getKey(), (String)v);
                continue;
            }
            dict.add(kv.getKey(), (V8Value)this.asJs(v));
        }
        return dict;
    }

    @Override
    public Map<String, ? super Object> asNativeObject(V8Object object) {
        String[] keys;
        HashMap<String, Object> mixed = new HashMap<String, Object>();
        block7: for (String k : keys = object.getKeys()) {
            if (k.length() > 0 && k.charAt(0) == '_') continue;
            int type = object.getType(k);
            switch (type) {
                case 2: {
                    mixed.put(k, object.getDouble(k));
                    continue block7;
                }
                case 1: {
                    mixed.put(k, object.getInteger(k));
                    continue block7;
                }
                case 3: {
                    mixed.put(k, object.getBoolean(k));
                    continue block7;
                }
                case 0: {
                    mixed.put(k, null);
                    continue block7;
                }
                case 4: {
                    mixed.put(k, object.getString(k));
                    continue block7;
                }
                default: {
                    mixed.put(k, object.getObject(k).toString());
                }
            }
        }
        return mixed;
    }
}

