/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.manticore;

import android.util.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class JsExecutor {
    private int jobCounter;
    private Thread executorThread;
    private ExecutorService singleMinded = Executors.newSingleThreadExecutor();

    public JsExecutor() {
        Future<Thread> future = this.singleMinded.submit(new Callable<Thread>(){

            @Override
            public Thread call() throws Exception {
                return Thread.currentThread();
            }
        });
        try {
            this.executorThread = future.get();
        }
        catch (InterruptedException ix) {
            throw new RuntimeException("Failed to create single threaded executor for the Javascript engine.", ix);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Failed to create single threaded executor for the Javascript engine.", ex);
        }
    }

    public void debug(String format, Object ... args) {
    }

    public void run(final Runnable r) {
        final int jobId = this.jobCounter++;
        if (Thread.currentThread() == this.executorThread) {
            this.debug("#%d start void immediate", jobId);
            try {
                r.run();
                this.debug("#%d end void immediate", jobId);
            }
            catch (Exception e) {
                this.debug("#%d end void immediate %s", jobId, e.toString());
                throw e;
            }
            return;
        }
        try {
            this.debug("#%d queue void wait", jobId);
            Exception executionException = this.singleMinded.submit(new Callable<Exception>(){

                @Override
                public Exception call() throws Exception {
                    try {
                        JsExecutor.this.debug("#%d start void wait", jobId);
                        r.run();
                        JsExecutor.this.debug("#%d done void wait", jobId);
                    }
                    catch (Exception x) {
                        return x;
                    }
                    return null;
                }
            }).get();
            this.debug("#%d completed void wait %s", jobId, executionException != null ? "exception" : "ok");
            if (executionException != null) {
                throw new RuntimeException(executionException);
            }
        }
        catch (InterruptedException e) {
            this.debug("#%d exception queuing %s", jobId, e.toString());
            Log.e((String)"RetailSDK", (String)"Internal Error", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.debug("#%d exception queuing %s", jobId, e.toString());
            Log.e((String)"RetailSDK", (String)"Internal Error", (Throwable)e);
        }
    }

    public <T> T run(final Callable<T> r) {
        final int jobId = this.jobCounter++;
        if (Thread.currentThread() == this.executorThread) {
            try {
                this.debug("#%d start T immediate", jobId);
                T retVal = r.call();
                this.debug("#%d end T immediate", jobId);
                return retVal;
            }
            catch (Exception e) {
                this.debug("#%d exception T immediate", jobId);
                throw new RuntimeException(e);
            }
        }
        try {
            this.debug("#%d queue T wait", jobId);
            Future task = this.singleMinded.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    JsExecutor.this.debug("#%d start void wait", jobId);
                    Object retVal = r.call();
                    JsExecutor.this.debug("#%d done void wait", jobId);
                    return retVal;
                }
            });
            Object retVal = task.get();
            this.debug("#%d completed T immediate", jobId);
            return retVal;
        }
        catch (InterruptedException e) {
            this.debug("#%d exception queuing %s", jobId, e.toString());
            Log.e((String)"RetailSDK", (String)"Internal Error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.debug("#%d exception queuing %s", jobId, e.toString());
            Log.e((String)"RetailSDK", (String)"Internal Error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void runNoWait(final Runnable r) {
        final int jobId = this.jobCounter++;
        if (Thread.currentThread() == this.executorThread) {
            this.debug("#%d immediate void noWait", jobId);
            try {
                r.run();
            }
            catch (Exception e) {
                this.debug("#%d exception void noWait %s", jobId, e.toString());
            }
            return;
        }
        this.debug("#%d queue void noWait", jobId);
        this.singleMinded.submit(new Runnable(){

            @Override
            public void run() {
                JsExecutor.this.debug("#%d start void noWait", jobId);
                try {
                    r.run();
                    JsExecutor.this.debug("#%d done void noWait", jobId);
                }
                catch (Exception e) {
                    JsExecutor.this.debug("#%d done void noWait %s", jobId, e.toString());
                    throw e;
                }
            }
        });
        this.debug("#%d queued void noWait", jobId);
    }
}

