/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.manticore;

import android.util.Base64;
import android.util.Log;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.V8Value;
import com.paypal.manticore.BuildConfig;
import com.paypal.manticore.ManticoreEngine;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class NativeServices {
    private static final String NETWORK_OFFLINE_CODE = "-1001";
    private static final String NETWORK_OFFLINE_MESSAGE = "Network Offline";
    ManticoreEngine engine;
    ScheduledExecutorService deferredFnExecutor = Executors.newScheduledThreadPool(1);
    OkHttpClient httpClient = new OkHttpClient();

    public NativeServices(ManticoreEngine engine) {
        this.engine = engine;
        engine.manticoreJsObject.registerJavaMethod((Object)this, "log", "log", new Class[]{String.class, String.class, Object.class});
        engine.manticoreJsObject.registerJavaMethod((Object)this, "http", "http", new Class[]{V8Object.class, V8Function.class});
        engine.manticoreJsObject.registerJavaMethod((Object)this, "setTimeout", "setTimeout", new Class[]{V8Function.class, Integer.class});
        engine.manticoreJsObject.registerJavaMethod((Object)this, "export", "export", new Class[]{V8Object.class});
        engine.v8.executeVoidScript("manticore.construct = function (C,args) {  function F() { return C.apply(this, args); }\n F.prototype = C.prototype;\n return new F(); }");
        engine.v8.executeVoidScript("manticore.newDate = function (t) { return new Date(t); }");
        engine.manticoreJsObject.add("platform", "android");
    }

    public void export(V8Object object) {
        String[] keys;
        if (object == null) {
            return;
        }
        V8Object exportedItems = this.engine.exportedItems;
        block8: for (String k : keys = object.getKeys()) {
            int type = object.getType(k);
            switch (type) {
                case 6: 
                case 7: {
                    exportedItems.add(k, (V8Value)object.getObject(k));
                    continue block8;
                }
                case 5: {
                    exportedItems.add(k, (V8Value)object.getArray(k));
                    continue block8;
                }
                case 4: {
                    exportedItems.add(k, object.getString(k));
                    continue block8;
                }
                case 3: {
                    exportedItems.add(k, object.getBoolean(k));
                    continue block8;
                }
                case 2: {
                    exportedItems.add(k, object.getDouble(k));
                    continue block8;
                }
                case 1: {
                    exportedItems.add(k, object.getInteger(k));
                }
            }
        }
    }

    public void log(String level, String component, Object messageValue) {
        if (BuildConfig.DEBUG) {
            String message = messageValue == V8.getUndefined() ? "undefined" : messageValue.toString();
            if ("ERROR".equalsIgnoreCase(level)) {
                Log.e((String)("PayPalRetailSDK:" + component), (String)message);
            } else if ("WARN".equalsIgnoreCase(level)) {
                Log.w((String)("PayPalRetailSDK:" + component), (String)message);
            } else if ("INFO".equalsIgnoreCase(level)) {
                Log.i((String)("PayPalRetailSDK:" + component), (String)message);
            } else {
                Log.d((String)("PayPalRetailSDK:" + component), (String)message);
            }
        }
    }

    public void http(V8Object options, V8Function jsCallback) {
        final V8Function callback = jsCallback.twin();
        String url = options.getString("url");
        Request.Builder httpRequestBuilder = new Request.Builder().url(url);
        String contentType = "application/x-www-form-urlencoded";
        if (options.contains("headers")) {
            V8Object headers = options.getObject("headers");
            for (String kv : headers.getKeys()) {
                String key = kv.toString();
                String value = headers.getString(kv);
                if ("Content-Type".equalsIgnoreCase(key)) {
                    contentType = value;
                }
                httpRequestBuilder.addHeader(key, value);
            }
        }
        String method = "GET";
        RequestBody body = null;
        RequestBody requestBody = body = options.contains("body") ? RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)options.getString("body")) : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)" ");
        if (options.contains("method")) {
            httpRequestBuilder.method(options.getString("method"), body);
        }
        String tmpformat = null;
        if (options.contains("format")) {
            tmpformat = options.getString("format");
        }
        final String format = tmpformat;
        final boolean isDebug = options.contains("debug");
        if (isDebug) {
            Log.d((String)"NativeServices", (String)"debuggable request");
        }
        this.httpClient.newCall(httpRequestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Request request, final IOException e) {
                if (isDebug) {
                    Log.d((String)"NativeServices", (String)"debuggable request");
                }
                NativeServices.this.engine.getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        V8Object vError = e instanceof UnknownHostException ? NativeServices.this.engine.asJsError(NativeServices.NETWORK_OFFLINE_MESSAGE, NativeServices.NETWORK_OFFLINE_CODE, e.getStackTrace().toString()) : NativeServices.this.engine.asJsError(e);
                        callback.call(NativeServices.this.engine.getManticoreJsObject(), NativeServices.this.engine.createJsArray().push((V8Value)vError));
                    }
                });
            }

            public void onResponse(final Response response) throws IOException {
                if (isDebug) {
                    Log.d((String)"NativeServices", (String)"debuggable request");
                }
                NativeServices.this.engine.getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        V8Object returnValue = NativeServices.this.engine.createJsObject();
                        returnValue.add("statusCode", response.code());
                        V8Object headers = NativeServices.this.engine.createJsObject();
                        for (String hdr : response.headers().names()) {
                            headers.add(hdr, response.header(hdr).toString());
                        }
                        returnValue.add("headers", (V8Value)headers);
                        try {
                            if (response.body().contentLength() != 0L) {
                                if ("json".equalsIgnoreCase(format)) {
                                    try {
                                        String body = response.body().string();
                                        if (body == null || body.length() == 0) {
                                            returnValue.add("body", (V8Value)((V8Object)null));
                                        }
                                        try {
                                            V8Object jsonBody = NativeServices.this.engine.v8.getObject("JSON").executeObjectFunction("parse", NativeServices.this.engine.createJsArray().push(body));
                                            returnValue.add("body", (V8Value)jsonBody);
                                        }
                                        catch (Exception x) {
                                            returnValue.add("body", (V8Value)((V8Object)null));
                                        }
                                    }
                                    catch (V8RuntimeException pe) {
                                        callback.call(NativeServices.this.engine.getManticoreJsObject(), NativeServices.this.engine.createJsArray().push((V8Value)NativeServices.this.engine.asJsError((Exception)((Object)pe))));
                                        return;
                                    }
                                    catch (ProtocolException ex) {
                                        returnValue.add("body", (V8Value)((V8Object)null));
                                    }
                                } else if (!"binary".equalsIgnoreCase(format)) {
                                    if (response.body().contentLength() != 0L) {
                                        returnValue.add("body", response.body().string());
                                    }
                                } else {
                                    try {
                                        if (response.body().contentLength() != 0L) {
                                            byte[] responseBody = response.body().bytes();
                                            returnValue.add("body", Base64.encodeToString((byte[])responseBody, (int)2));
                                        }
                                    }
                                    catch (Exception ex) {
                                        callback.call(NativeServices.this.engine.getManticoreJsObject(), NativeServices.this.engine.createJsArray().push((V8Value)NativeServices.this.engine.asJsError(ex.getMessage(), "0", Arrays.toString(ex.getStackTrace()))));
                                        return;
                                    }
                                }
                            }
                            callback.call(NativeServices.this.engine.getManticoreJsObject(), NativeServices.this.engine.createJsArray().pushUndefined().push((V8Value)returnValue));
                        }
                        catch (Exception x) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            x.printStackTrace(pw);
                            NativeServices.this.log("ERROR", "manticore", x.toString() + "\n" + sw.toString());
                        }
                    }
                });
            }
        });
    }

    public V8Object setTimeout(V8Function func, Integer timeoutMsec) {
        final V8Function myFunction = func.twin();
        V8Object returnValue = this.engine.createJsObject();
        final ScheduledFuture<?> future = this.deferredFnExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                NativeServices.this.engine.getExecutor().runNoWait(new Runnable(){

                    @Override
                    public void run() {
                        myFunction.call((V8Object)myFunction, null);
                        myFunction.release();
                    }
                });
            }
        }, (long)timeoutMsec.intValue(), TimeUnit.MILLISECONDS);
        JavaVoidCallback callback = new JavaVoidCallback(){

            public void invoke(V8Object v8Object, V8Array v8Array) {
                future.cancel(false);
            }
        };
        returnValue.registerJavaMethod(callback, "cancel");
        return returnValue;
    }
}

