/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for Address type.
 */
public class Address {
    private String addressLine1;
    private String addressLine2;
    private String adminArea2;
    private String adminArea1;
    private String postalCode;
    private String countryCode;

    /**
     * Default constructor.
     */
    public Address() {
    }

    /**
     * Initialization constructor.
     * @param  countryCode  String value for countryCode.
     * @param  addressLine1  String value for addressLine1.
     * @param  addressLine2  String value for addressLine2.
     * @param  adminArea2  String value for adminArea2.
     * @param  adminArea1  String value for adminArea1.
     * @param  postalCode  String value for postalCode.
     */
    public Address(
            String countryCode,
            String addressLine1,
            String addressLine2,
            String adminArea2,
            String adminArea1,
            String postalCode) {
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.adminArea2 = adminArea2;
        this.adminArea1 = adminArea1;
        this.postalCode = postalCode;
        this.countryCode = countryCode;
    }

    /**
     * Getter for AddressLine1.
     * The first line of the address, such as number and street, for example, `173 Drury Lane`.
     * Needed for data entry, and Compliance and Risk checks. This field needs to pass the full
     * address.
     * @return Returns the String
     */
    @JsonGetter("address_line_1")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAddressLine1() {
        return addressLine1;
    }

    /**
     * Setter for AddressLine1.
     * The first line of the address, such as number and street, for example, `173 Drury Lane`.
     * Needed for data entry, and Compliance and Risk checks. This field needs to pass the full
     * address.
     * @param addressLine1 Value for String
     */
    @JsonSetter("address_line_1")
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    /**
     * Getter for AddressLine2.
     * The second line of the address, for example, a suite or apartment number.
     * @return Returns the String
     */
    @JsonGetter("address_line_2")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAddressLine2() {
        return addressLine2;
    }

    /**
     * Setter for AddressLine2.
     * The second line of the address, for example, a suite or apartment number.
     * @param addressLine2 Value for String
     */
    @JsonSetter("address_line_2")
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    /**
     * Getter for AdminArea2.
     * A city, town, or village. Smaller than `admin_area_level_1`.
     * @return Returns the String
     */
    @JsonGetter("admin_area_2")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAdminArea2() {
        return adminArea2;
    }

    /**
     * Setter for AdminArea2.
     * A city, town, or village. Smaller than `admin_area_level_1`.
     * @param adminArea2 Value for String
     */
    @JsonSetter("admin_area_2")
    public void setAdminArea2(String adminArea2) {
        this.adminArea2 = adminArea2;
    }

    /**
     * Getter for AdminArea1.
     * The highest-level sub-division in a country, which is usually a province, state, or
     * ISO-3166-2 subdivision. This data is formatted for postal delivery, for example, `CA` and not
     * `California`. Value, by country, is: UK. A county. US. A state. Canada. A province. Japan. A
     * prefecture. Switzerland. A *kanton*.
     * @return Returns the String
     */
    @JsonGetter("admin_area_1")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAdminArea1() {
        return adminArea1;
    }

    /**
     * Setter for AdminArea1.
     * The highest-level sub-division in a country, which is usually a province, state, or
     * ISO-3166-2 subdivision. This data is formatted for postal delivery, for example, `CA` and not
     * `California`. Value, by country, is: UK. A county. US. A state. Canada. A province. Japan. A
     * prefecture. Switzerland. A *kanton*.
     * @param adminArea1 Value for String
     */
    @JsonSetter("admin_area_1")
    public void setAdminArea1(String adminArea1) {
        this.adminArea1 = adminArea1;
    }

    /**
     * Getter for PostalCode.
     * The postal code, which is the ZIP code or equivalent. Typically required for countries with a
     * postal code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     * @return Returns the String
     */
    @JsonGetter("postal_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPostalCode() {
        return postalCode;
    }

    /**
     * Setter for PostalCode.
     * The postal code, which is the ZIP code or equivalent. Typically required for countries with a
     * postal code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     * @param postalCode Value for String
     */
    @JsonSetter("postal_code")
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /**
     * Getter for CountryCode.
     * The [2-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [2-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Converts this Address into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "Address [" + "countryCode=" + countryCode + ", addressLine1=" + addressLine1
                + ", addressLine2=" + addressLine2 + ", adminArea2=" + adminArea2 + ", adminArea1="
                + adminArea1 + ", postalCode=" + postalCode + "]";
    }

    /**
     * Builds a new {@link Address.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link Address.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(countryCode)
                .addressLine1(getAddressLine1())
                .addressLine2(getAddressLine2())
                .adminArea2(getAdminArea2())
                .adminArea1(getAdminArea1())
                .postalCode(getPostalCode());
        return builder;
    }

    /**
     * Class to build instances of {@link Address}.
     */
    public static class Builder {
        private String countryCode;
        private String addressLine1;
        private String addressLine2;
        private String adminArea2;
        private String adminArea1;
        private String postalCode;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  countryCode  String value for countryCode.
         */
        public Builder(String countryCode) {
            this.countryCode = countryCode;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for addressLine1.
         * @param  addressLine1  String value for addressLine1.
         * @return Builder
         */
        public Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        /**
         * Setter for addressLine2.
         * @param  addressLine2  String value for addressLine2.
         * @return Builder
         */
        public Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        /**
         * Setter for adminArea2.
         * @param  adminArea2  String value for adminArea2.
         * @return Builder
         */
        public Builder adminArea2(String adminArea2) {
            this.adminArea2 = adminArea2;
            return this;
        }

        /**
         * Setter for adminArea1.
         * @param  adminArea1  String value for adminArea1.
         * @return Builder
         */
        public Builder adminArea1(String adminArea1) {
            this.adminArea1 = adminArea1;
            return this;
        }

        /**
         * Setter for postalCode.
         * @param  postalCode  String value for postalCode.
         * @return Builder
         */
        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        /**
         * Builds a new {@link Address} object using the set fields.
         * @return {@link Address}
         */
        public Address build() {
            return new Address(countryCode, addressLine1, addressLine2, adminArea2, adminArea1,
                    postalCode);
        }
    }
}
