/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for BlikPaymentObject type.
 */
public class BlikPaymentObject {
    private String name;
    private String countryCode;
    private String email;
    private BlikOneClickPaymentObject oneClick;

    /**
     * Default constructor.
     */
    public BlikPaymentObject() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  countryCode  String value for countryCode.
     * @param  email  String value for email.
     * @param  oneClick  BlikOneClickPaymentObject value for oneClick.
     */
    public BlikPaymentObject(
            String name,
            String countryCode,
            String email,
            BlikOneClickPaymentObject oneClick) {
        this.name = name;
        this.countryCode = countryCode;
        this.email = email;
        this.oneClick = oneClick;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Getter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmail() {
        return email;
    }

    /**
     * Setter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param email Value for String
     */
    @JsonSetter("email")
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Getter for OneClick.
     * Information used to pay using BLIK one-click flow.
     * @return Returns the BlikOneClickPaymentObject
     */
    @JsonGetter("one_click")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public BlikOneClickPaymentObject getOneClick() {
        return oneClick;
    }

    /**
     * Setter for OneClick.
     * Information used to pay using BLIK one-click flow.
     * @param oneClick Value for BlikOneClickPaymentObject
     */
    @JsonSetter("one_click")
    public void setOneClick(BlikOneClickPaymentObject oneClick) {
        this.oneClick = oneClick;
    }

    /**
     * Converts this BlikPaymentObject into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "BlikPaymentObject [" + "name=" + name + ", countryCode=" + countryCode + ", email="
                + email + ", oneClick=" + oneClick + "]";
    }

    /**
     * Builds a new {@link BlikPaymentObject.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link BlikPaymentObject.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .countryCode(getCountryCode())
                .email(getEmail())
                .oneClick(getOneClick());
        return builder;
    }

    /**
     * Class to build instances of {@link BlikPaymentObject}.
     */
    public static class Builder {
        private String name;
        private String countryCode;
        private String email;
        private BlikOneClickPaymentObject oneClick;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for email.
         * @param  email  String value for email.
         * @return Builder
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        /**
         * Setter for oneClick.
         * @param  oneClick  BlikOneClickPaymentObject value for oneClick.
         * @return Builder
         */
        public Builder oneClick(BlikOneClickPaymentObject oneClick) {
            this.oneClick = oneClick;
            return this;
        }

        /**
         * Builds a new {@link BlikPaymentObject} object using the set fields.
         * @return {@link BlikPaymentObject}
         */
        public BlikPaymentObject build() {
            return new BlikPaymentObject(name, countryCode, email, oneClick);
        }
    }
}
