/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CardSupplementaryData type.
 */
public class CardSupplementaryData {
    private Level2CardProcessingData level2;
    private Level3CardProcessingData level3;

    /**
     * Default constructor.
     */
    public CardSupplementaryData() {
    }

    /**
     * Initialization constructor.
     * @param  level2  Level2CardProcessingData value for level2.
     * @param  level3  Level3CardProcessingData value for level3.
     */
    public CardSupplementaryData(
            Level2CardProcessingData level2,
            Level3CardProcessingData level3) {
        this.level2 = level2;
        this.level3 = level3;
    }

    /**
     * Getter for Level2.
     * The level 2 card processing data collections. If your merchant account has been configured
     * for Level 2 processing this field will be passed to the processor on your behalf. Please
     * contact your PayPal Technical Account Manager to define level 2 data for your business.
     * @return Returns the Level2CardProcessingData
     */
    @JsonGetter("level_2")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Level2CardProcessingData getLevel2() {
        return level2;
    }

    /**
     * Setter for Level2.
     * The level 2 card processing data collections. If your merchant account has been configured
     * for Level 2 processing this field will be passed to the processor on your behalf. Please
     * contact your PayPal Technical Account Manager to define level 2 data for your business.
     * @param level2 Value for Level2CardProcessingData
     */
    @JsonSetter("level_2")
    public void setLevel2(Level2CardProcessingData level2) {
        this.level2 = level2;
    }

    /**
     * Getter for Level3.
     * The level 3 card processing data collections, If your merchant account has been configured
     * for Level 3 processing this field will be passed to the processor on your behalf. Please
     * contact your PayPal Technical Account Manager to define level 3 data for your business.
     * @return Returns the Level3CardProcessingData
     */
    @JsonGetter("level_3")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Level3CardProcessingData getLevel3() {
        return level3;
    }

    /**
     * Setter for Level3.
     * The level 3 card processing data collections, If your merchant account has been configured
     * for Level 3 processing this field will be passed to the processor on your behalf. Please
     * contact your PayPal Technical Account Manager to define level 3 data for your business.
     * @param level3 Value for Level3CardProcessingData
     */
    @JsonSetter("level_3")
    public void setLevel3(Level3CardProcessingData level3) {
        this.level3 = level3;
    }

    /**
     * Converts this CardSupplementaryData into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CardSupplementaryData [" + "level2=" + level2 + ", level3=" + level3 + "]";
    }

    /**
     * Builds a new {@link CardSupplementaryData.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CardSupplementaryData.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .level2(getLevel2())
                .level3(getLevel3());
        return builder;
    }

    /**
     * Class to build instances of {@link CardSupplementaryData}.
     */
    public static class Builder {
        private Level2CardProcessingData level2;
        private Level3CardProcessingData level3;



        /**
         * Setter for level2.
         * @param  level2  Level2CardProcessingData value for level2.
         * @return Builder
         */
        public Builder level2(Level2CardProcessingData level2) {
            this.level2 = level2;
            return this;
        }

        /**
         * Setter for level3.
         * @param  level3  Level3CardProcessingData value for level3.
         * @return Builder
         */
        public Builder level3(Level3CardProcessingData level3) {
            this.level3 = level3;
            return this;
        }

        /**
         * Builds a new {@link CardSupplementaryData} object using the set fields.
         * @return {@link CardSupplementaryData}
         */
        public CardSupplementaryData build() {
            return new CardSupplementaryData(level2, level3);
        }
    }
}
