/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CreatePaymentTokenInput type.
 */
public class CreatePaymentTokenInput {
    private String contentType;
    private PaymentTokenRequest body;
    private String paypalRequestId;

    /**
     * Default constructor.
     */
    public CreatePaymentTokenInput() {
        contentType = "application/json";
    }

    /**
     * Initialization constructor.
     * @param  contentType  String value for contentType.
     * @param  body  PaymentTokenRequest value for body.
     * @param  paypalRequestId  String value for paypalRequestId.
     */
    public CreatePaymentTokenInput(
            String contentType,
            PaymentTokenRequest body,
            String paypalRequestId) {
        this.contentType = contentType;
        this.body = body;
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for Body.
     * Payment Token creation with a financial instrument and an optional customer_id.
     * @return Returns the PaymentTokenRequest
     */
    @JsonGetter("body")
    public PaymentTokenRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * Payment Token creation with a financial instrument and an optional customer_id.
     * @param body Value for PaymentTokenRequest
     */
    @JsonSetter("body")
    public void setBody(PaymentTokenRequest body) {
        this.body = body;
    }

    /**
     * Getter for PaypalRequestId.
     * The server stores keys for 3 hours.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Request-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return paypalRequestId;
    }

    /**
     * Setter for PaypalRequestId.
     * The server stores keys for 3 hours.
     * @param paypalRequestId Value for String
     */
    @JsonSetter("PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Converts this CreatePaymentTokenInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CreatePaymentTokenInput [" + "contentType=" + contentType + ", body=" + body
                + ", paypalRequestId=" + paypalRequestId + "]";
    }

    /**
     * Builds a new {@link CreatePaymentTokenInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CreatePaymentTokenInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(contentType, body)
                .paypalRequestId(getPaypalRequestId());
        return builder;
    }

    /**
     * Class to build instances of {@link CreatePaymentTokenInput}.
     */
    public static class Builder {
        private String contentType = "application/json";
        private PaymentTokenRequest body;
        private String paypalRequestId;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  contentType  String value for contentType.
         * @param  body  PaymentTokenRequest value for body.
         */
        public Builder(String contentType, PaymentTokenRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  PaymentTokenRequest value for body.
         * @return Builder
         */
        public Builder body(PaymentTokenRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Setter for paypalRequestId.
         * @param  paypalRequestId  String value for paypalRequestId.
         * @return Builder
         */
        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        /**
         * Builds a new {@link CreatePaymentTokenInput} object using the set fields.
         * @return {@link CreatePaymentTokenInput}
         */
        public CreatePaymentTokenInput build() {
            return new CreatePaymentTokenInput(contentType, body, paypalRequestId);
        }
    }
}
