/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CustomerResponse type.
 */
public class CustomerResponse {
    private String id;
    private String merchantCustomerId;

    /**
     * Default constructor.
     */
    public CustomerResponse() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  merchantCustomerId  String value for merchantCustomerId.
     */
    public CustomerResponse(
            String id,
            String merchantCustomerId) {
        this.id = id;
        this.merchantCustomerId = merchantCustomerId;
    }

    /**
     * Getter for Id.
     * The unique ID for a customer generated by PayPal.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The unique ID for a customer generated by PayPal.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for MerchantCustomerId.
     * Merchants and partners may already have a data-store where their customer information is
     * persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your
     * representation of a customer.
     * @return Returns the String
     */
    @JsonGetter("merchant_customer_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getMerchantCustomerId() {
        return merchantCustomerId;
    }

    /**
     * Setter for MerchantCustomerId.
     * Merchants and partners may already have a data-store where their customer information is
     * persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your
     * representation of a customer.
     * @param merchantCustomerId Value for String
     */
    @JsonSetter("merchant_customer_id")
    public void setMerchantCustomerId(String merchantCustomerId) {
        this.merchantCustomerId = merchantCustomerId;
    }

    /**
     * Converts this CustomerResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CustomerResponse [" + "id=" + id + ", merchantCustomerId=" + merchantCustomerId
                + "]";
    }

    /**
     * Builds a new {@link CustomerResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CustomerResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .merchantCustomerId(getMerchantCustomerId());
        return builder;
    }

    /**
     * Class to build instances of {@link CustomerResponse}.
     */
    public static class Builder {
        private String id;
        private String merchantCustomerId;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for merchantCustomerId.
         * @param  merchantCustomerId  String value for merchantCustomerId.
         * @return Builder
         */
        public Builder merchantCustomerId(String merchantCustomerId) {
            this.merchantCustomerId = merchantCustomerId;
            return this;
        }

        /**
         * Builds a new {@link CustomerResponse} object using the set fields.
         * @return {@link CustomerResponse}
         */
        public CustomerResponse build() {
            return new CustomerResponse(id, merchantCustomerId);
        }
    }
}
