/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PaymentTokenResponsePaymentSource type.
 */
public class PaymentTokenResponsePaymentSource {
    private CardPaymentTokenEntity card;
    private PaypalPaymentToken paypal;
    private VenmoPaymentToken venmo;
    private ApplePayPaymentToken applePay;

    /**
     * Default constructor.
     */
    public PaymentTokenResponsePaymentSource() {
    }

    /**
     * Initialization constructor.
     * @param  card  CardPaymentTokenEntity value for card.
     * @param  paypal  PaypalPaymentToken value for paypal.
     * @param  venmo  VenmoPaymentToken value for venmo.
     * @param  applePay  ApplePayPaymentToken value for applePay.
     */
    public PaymentTokenResponsePaymentSource(
            CardPaymentTokenEntity card,
            PaypalPaymentToken paypal,
            VenmoPaymentToken venmo,
            ApplePayPaymentToken applePay) {
        this.card = card;
        this.paypal = paypal;
        this.venmo = venmo;
        this.applePay = applePay;
    }

    /**
     * Getter for Card.
     * Full representation of a Card Payment Token including network token.
     * @return Returns the CardPaymentTokenEntity
     */
    @JsonGetter("card")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardPaymentTokenEntity getCard() {
        return card;
    }

    /**
     * Setter for Card.
     * Full representation of a Card Payment Token including network token.
     * @param card Value for CardPaymentTokenEntity
     */
    @JsonSetter("card")
    public void setCard(CardPaymentTokenEntity card) {
        this.card = card;
    }

    /**
     * Getter for Paypal.
     * @return Returns the PaypalPaymentToken
     */
    @JsonGetter("paypal")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalPaymentToken getPaypal() {
        return paypal;
    }

    /**
     * Setter for Paypal.
     * @param paypal Value for PaypalPaymentToken
     */
    @JsonSetter("paypal")
    public void setPaypal(PaypalPaymentToken paypal) {
        this.paypal = paypal;
    }

    /**
     * Getter for Venmo.
     * @return Returns the VenmoPaymentToken
     */
    @JsonGetter("venmo")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VenmoPaymentToken getVenmo() {
        return venmo;
    }

    /**
     * Setter for Venmo.
     * @param venmo Value for VenmoPaymentToken
     */
    @JsonSetter("venmo")
    public void setVenmo(VenmoPaymentToken venmo) {
        this.venmo = venmo;
    }

    /**
     * Getter for ApplePay.
     * A resource representing a response for Apple Pay.
     * @return Returns the ApplePayPaymentToken
     */
    @JsonGetter("apple_pay")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ApplePayPaymentToken getApplePay() {
        return applePay;
    }

    /**
     * Setter for ApplePay.
     * A resource representing a response for Apple Pay.
     * @param applePay Value for ApplePayPaymentToken
     */
    @JsonSetter("apple_pay")
    public void setApplePay(ApplePayPaymentToken applePay) {
        this.applePay = applePay;
    }

    /**
     * Converts this PaymentTokenResponsePaymentSource into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaymentTokenResponsePaymentSource [" + "card=" + card + ", paypal=" + paypal
                + ", venmo=" + venmo + ", applePay=" + applePay + "]";
    }

    /**
     * Builds a new {@link PaymentTokenResponsePaymentSource.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaymentTokenResponsePaymentSource.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .card(getCard())
                .paypal(getPaypal())
                .venmo(getVenmo())
                .applePay(getApplePay());
        return builder;
    }

    /**
     * Class to build instances of {@link PaymentTokenResponsePaymentSource}.
     */
    public static class Builder {
        private CardPaymentTokenEntity card;
        private PaypalPaymentToken paypal;
        private VenmoPaymentToken venmo;
        private ApplePayPaymentToken applePay;



        /**
         * Setter for card.
         * @param  card  CardPaymentTokenEntity value for card.
         * @return Builder
         */
        public Builder card(CardPaymentTokenEntity card) {
            this.card = card;
            return this;
        }

        /**
         * Setter for paypal.
         * @param  paypal  PaypalPaymentToken value for paypal.
         * @return Builder
         */
        public Builder paypal(PaypalPaymentToken paypal) {
            this.paypal = paypal;
            return this;
        }

        /**
         * Setter for venmo.
         * @param  venmo  VenmoPaymentToken value for venmo.
         * @return Builder
         */
        public Builder venmo(VenmoPaymentToken venmo) {
            this.venmo = venmo;
            return this;
        }

        /**
         * Setter for applePay.
         * @param  applePay  ApplePayPaymentToken value for applePay.
         * @return Builder
         */
        public Builder applePay(ApplePayPaymentToken applePay) {
            this.applePay = applePay;
            return this;
        }

        /**
         * Builds a new {@link PaymentTokenResponsePaymentSource} object using the set fields.
         * @return {@link PaymentTokenResponsePaymentSource}
         */
        public PaymentTokenResponsePaymentSource build() {
            return new PaymentTokenResponsePaymentSource(card, paypal, venmo, applePay);
        }
    }
}
