/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for ShippingOptionsPurchaseUnit type.
 */
public class ShippingOptionsPurchaseUnit {
    private String referenceId;
    private AmountWithBreakdown amount;
    private List<ShippingOption> shippingOptions;

    /**
     * Default constructor.
     */
    public ShippingOptionsPurchaseUnit() {
    }

    /**
     * Initialization constructor.
     * @param  referenceId  String value for referenceId.
     * @param  amount  AmountWithBreakdown value for amount.
     * @param  shippingOptions  List of ShippingOption value for shippingOptions.
     */
    public ShippingOptionsPurchaseUnit(
            String referenceId,
            AmountWithBreakdown amount,
            List<ShippingOption> shippingOptions) {
        this.referenceId = referenceId;
        this.amount = amount;
        this.shippingOptions = shippingOptions;
    }

    /**
     * Getter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`. Note: If there are
     * multiple purchase units, reference_id is required for each purchase unit.
     * @return Returns the String
     */
    @JsonGetter("reference_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return referenceId;
    }

    /**
     * Setter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`. Note: If there are
     * multiple purchase units, reference_id is required for each purchase unit.
     * @param referenceId Value for String
     */
    @JsonSetter("reference_id")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    /**
     * Getter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @return Returns the AmountWithBreakdown
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public AmountWithBreakdown getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @param amount Value for AmountWithBreakdown
     */
    @JsonSetter("amount")
    public void setAmount(AmountWithBreakdown amount) {
        this.amount = amount;
    }

    /**
     * Getter for ShippingOptions.
     * An array of shipping options that the payee or merchant offers to the payer to ship or pick
     * up their items.
     * @return Returns the List of ShippingOption
     */
    @JsonGetter("shipping_options")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<ShippingOption> getShippingOptions() {
        return shippingOptions;
    }

    /**
     * Setter for ShippingOptions.
     * An array of shipping options that the payee or merchant offers to the payer to ship or pick
     * up their items.
     * @param shippingOptions Value for List of ShippingOption
     */
    @JsonSetter("shipping_options")
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    /**
     * Converts this ShippingOptionsPurchaseUnit into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ShippingOptionsPurchaseUnit [" + "referenceId=" + referenceId + ", amount=" + amount
                + ", shippingOptions=" + shippingOptions + "]";
    }

    /**
     * Builds a new {@link ShippingOptionsPurchaseUnit.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ShippingOptionsPurchaseUnit.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .referenceId(getReferenceId())
                .amount(getAmount())
                .shippingOptions(getShippingOptions());
        return builder;
    }

    /**
     * Class to build instances of {@link ShippingOptionsPurchaseUnit}.
     */
    public static class Builder {
        private String referenceId;
        private AmountWithBreakdown amount;
        private List<ShippingOption> shippingOptions;



        /**
         * Setter for referenceId.
         * @param  referenceId  String value for referenceId.
         * @return Builder
         */
        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  AmountWithBreakdown value for amount.
         * @return Builder
         */
        public Builder amount(AmountWithBreakdown amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Setter for shippingOptions.
         * @param  shippingOptions  List of ShippingOption value for shippingOptions.
         * @return Builder
         */
        public Builder shippingOptions(List<ShippingOption> shippingOptions) {
            this.shippingOptions = shippingOptions;
            return this;
        }

        /**
         * Builds a new {@link ShippingOptionsPurchaseUnit} object using the set fields.
         * @return {@link ShippingOptionsPurchaseUnit}
         */
        public ShippingOptionsPurchaseUnit build() {
            return new ShippingOptionsPurchaseUnit(referenceId, amount, shippingOptions);
        }
    }
}
