/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VenmoWalletRequest type.
 */
public class VenmoWalletRequest {
    private String vaultId;
    private String emailAddress;
    private VenmoWalletExperienceContext experienceContext;
    private VenmoWalletAdditionalAttributes attributes;

    /**
     * Default constructor.
     */
    public VenmoWalletRequest() {
    }

    /**
     * Initialization constructor.
     * @param  vaultId  String value for vaultId.
     * @param  emailAddress  String value for emailAddress.
     * @param  experienceContext  VenmoWalletExperienceContext value for experienceContext.
     * @param  attributes  VenmoWalletAdditionalAttributes value for attributes.
     */
    public VenmoWalletRequest(
            String vaultId,
            String emailAddress,
            VenmoWalletExperienceContext experienceContext,
            VenmoWalletAdditionalAttributes attributes) {
        this.vaultId = vaultId;
        this.emailAddress = emailAddress;
        this.experienceContext = experienceContext;
        this.attributes = attributes;
    }

    /**
     * Getter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @return Returns the String
     */
    @JsonGetter("vault_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getVaultId() {
        return vaultId;
    }

    /**
     * Setter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @param vaultId Value for String
     */
    @JsonSetter("vault_id")
    public void setVaultId(String vaultId) {
        this.vaultId = vaultId;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the buyer experience during the approval process for payment with Venmo. Note:
     * Partners and Marketplaces might configure shipping_preference during partner account setup,
     * which overrides the request values.
     * @return Returns the VenmoWalletExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VenmoWalletExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the buyer experience during the approval process for payment with Venmo. Note:
     * Partners and Marketplaces might configure shipping_preference during partner account setup,
     * which overrides the request values.
     * @param experienceContext Value for VenmoWalletExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(VenmoWalletExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Attributes.
     * Additional attributes associated with the use of this Venmo Wallet.
     * @return Returns the VenmoWalletAdditionalAttributes
     */
    @JsonGetter("attributes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VenmoWalletAdditionalAttributes getAttributes() {
        return attributes;
    }

    /**
     * Setter for Attributes.
     * Additional attributes associated with the use of this Venmo Wallet.
     * @param attributes Value for VenmoWalletAdditionalAttributes
     */
    @JsonSetter("attributes")
    public void setAttributes(VenmoWalletAdditionalAttributes attributes) {
        this.attributes = attributes;
    }

    /**
     * Converts this VenmoWalletRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VenmoWalletRequest [" + "vaultId=" + vaultId + ", emailAddress=" + emailAddress
                + ", experienceContext=" + experienceContext + ", attributes=" + attributes + "]";
    }

    /**
     * Builds a new {@link VenmoWalletRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VenmoWalletRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .vaultId(getVaultId())
                .emailAddress(getEmailAddress())
                .experienceContext(getExperienceContext())
                .attributes(getAttributes());
        return builder;
    }

    /**
     * Class to build instances of {@link VenmoWalletRequest}.
     */
    public static class Builder {
        private String vaultId;
        private String emailAddress;
        private VenmoWalletExperienceContext experienceContext;
        private VenmoWalletAdditionalAttributes attributes;



        /**
         * Setter for vaultId.
         * @param  vaultId  String value for vaultId.
         * @return Builder
         */
        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  VenmoWalletExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(VenmoWalletExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Setter for attributes.
         * @param  attributes  VenmoWalletAdditionalAttributes value for attributes.
         * @return Builder
         */
        public Builder attributes(VenmoWalletAdditionalAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Builds a new {@link VenmoWalletRequest} object using the set fields.
         * @return {@link VenmoWalletRequest}
         */
        public VenmoWalletRequest build() {
            return new VenmoWalletRequest(vaultId, emailAddress, experienceContext, attributes);
        }
    }
}
