/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.utilities;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.File;
import io.apimatic.coreinterfaces.type.CoreFileWrapper;

/**
 * Class to wrap file and contentType to be sent as part of a HTTP request.
 */
public class FileWrapper implements CoreFileWrapper {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private File file;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String contentType;

    /**
     * Initialization constructor.
     * @param file File object to be wrapped
     * @param contentType content type of file
     */
    public FileWrapper(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    /**
     * Initialization constructor.
     * @param file File object to be wrapped
     */
    public FileWrapper(File file) {
        this.file = file;
    }

    /**
     * Getter for file.
     * @return File instance
     */
    public File getFile() {
        return file;
    }

    /**
     * Getter for loggable file.
     * @return loggable string of file.
     */
    @SuppressWarnings("unused")
    private String getLoggableFile() {
        return file.getName();
    }

    /**
     * Getter for content type.
     * @return content type of the file
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * Converts FileWrapper object into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "FileWrapper [fileName=" + (file != null ? file.getName() : "") + ", contentType=" + contentType + "]";
    }
}
