/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.CreatePaymentTokenInput;
import com.paypal.sdk.models.CreateSetupTokenInput;
import com.paypal.sdk.models.CustomerVaultPaymentTokensResponse;
import com.paypal.sdk.models.ListCustomerPaymentTokensInput;
import com.paypal.sdk.models.PaymentTokenResponse;
import com.paypal.sdk.models.SetupTokenResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class VaultController
extends BaseController {
    public VaultController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<PaymentTokenResponse> createPaymentToken(CreatePaymentTokenInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCreatePaymentTokenRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<PaymentTokenResponse>> createPaymentTokenAsync(CreatePaymentTokenInput input) {
        try {
            return this.prepareCreatePaymentTokenRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentTokenResponse>, ApiException> prepareCreatePaymentTokenRequest(CreatePaymentTokenInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/payment-tokens").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentTokenResponse)ApiHelper.deserialize((String)response, PaymentTokenResponse.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"Request contains reference to resources that do not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<CustomerVaultPaymentTokensResponse> listCustomerPaymentTokens(ListCustomerPaymentTokensInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareListCustomerPaymentTokensRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<CustomerVaultPaymentTokensResponse>> listCustomerPaymentTokensAsync(ListCustomerPaymentTokensInput input) {
        try {
            return this.prepareListCustomerPaymentTokensRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<CustomerVaultPaymentTokensResponse>, ApiException> prepareListCustomerPaymentTokensRequest(ListCustomerPaymentTokensInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/payment-tokens").queryParam(param -> param.key("customer_id").value((Object)input.getCustomerId())).queryParam(param -> param.key("page_size").value((Object)input.getPageSize()).isRequired(false)).queryParam(param -> param.key("page").value((Object)input.getPage()).isRequired(false)).queryParam(param -> param.key("total_required").value((Object)input.getTotalRequired()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (CustomerVaultPaymentTokensResponse)ApiHelper.deserialize((String)response, CustomerVaultPaymentTokensResponse.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<PaymentTokenResponse> getPaymentToken(String id) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetPaymentTokenRequest(id).execute();
    }

    public CompletableFuture<ApiResponse<PaymentTokenResponse>> getPaymentTokenAsync(String id) {
        try {
            return this.prepareGetPaymentTokenRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<PaymentTokenResponse>, ApiException> prepareGetPaymentTokenRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/payment-tokens/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (PaymentTokenResponse)ApiHelper.deserialize((String)response, PaymentTokenResponse.class)).nullify404(false).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Void> deletePaymentToken(String id) throws ApiException, IOException {
        return (ApiResponse)this.prepareDeletePaymentTokenRequest(id).execute();
    }

    public CompletableFuture<ApiResponse<Void>> deletePaymentTokenAsync(String id) {
        try {
            return this.prepareDeletePaymentTokenRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Void>, ApiException> prepareDeletePaymentTokenRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/payment-tokens/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<SetupTokenResponse> createSetupToken(CreateSetupTokenInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCreateSetupTokenRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<SetupTokenResponse>> createSetupTokenAsync(CreateSetupTokenInput input) {
        try {
            return this.prepareCreateSetupTokenRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<SetupTokenResponse>, ApiException> prepareCreateSetupTokenRequest(CreateSetupTokenInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/setup-tokens").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (SetupTokenResponse)ApiHelper.deserialize((String)response, SetupTokenResponse.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<SetupTokenResponse> getSetupToken(String id) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetSetupTokenRequest(id).execute();
    }

    public CompletableFuture<ApiResponse<SetupTokenResponse>> getSetupTokenAsync(String id) {
        try {
            return this.prepareGetSetupTokenRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<SetupTokenResponse>, ApiException> prepareGetSetupTokenRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v3/vault/setup-tokens/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (SetupTokenResponse)ApiHelper.deserialize((String)response, SetupTokenResponse.class)).nullify404(false).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

