/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class BancontactPaymentObject {
    private String name;
    private String countryCode;
    private String bic;
    private String ibanLastChars;
    private String cardLastDigits;

    public BancontactPaymentObject() {
    }

    public BancontactPaymentObject(String name, String countryCode, String bic, String ibanLastChars, String cardLastDigits) {
        this.name = name;
        this.countryCode = countryCode;
        this.bic = bic;
        this.ibanLastChars = ibanLastChars;
        this.cardLastDigits = cardLastDigits;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="country_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonSetter(value="country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonGetter(value="bic")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBic() {
        return this.bic;
    }

    @JsonSetter(value="bic")
    public void setBic(String bic) {
        this.bic = bic;
    }

    @JsonGetter(value="iban_last_chars")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIbanLastChars() {
        return this.ibanLastChars;
    }

    @JsonSetter(value="iban_last_chars")
    public void setIbanLastChars(String ibanLastChars) {
        this.ibanLastChars = ibanLastChars;
    }

    @JsonGetter(value="card_last_digits")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardLastDigits() {
        return this.cardLastDigits;
    }

    @JsonSetter(value="card_last_digits")
    public void setCardLastDigits(String cardLastDigits) {
        this.cardLastDigits = cardLastDigits;
    }

    public String toString() {
        return "BancontactPaymentObject [name=" + this.name + ", countryCode=" + this.countryCode + ", bic=" + this.bic + ", ibanLastChars=" + this.ibanLastChars + ", cardLastDigits=" + this.cardLastDigits + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).countryCode(this.getCountryCode()).bic(this.getBic()).ibanLastChars(this.getIbanLastChars()).cardLastDigits(this.getCardLastDigits());
        return builder;
    }

    public static class Builder {
        private String name;
        private String countryCode;
        private String bic;
        private String ibanLastChars;
        private String cardLastDigits;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder bic(String bic) {
            this.bic = bic;
            return this;
        }

        public Builder ibanLastChars(String ibanLastChars) {
            this.ibanLastChars = ibanLastChars;
            return this;
        }

        public Builder cardLastDigits(String cardLastDigits) {
            this.cardLastDigits = cardLastDigits;
            return this;
        }

        public BancontactPaymentObject build() {
            return new BancontactPaymentObject(this.name, this.countryCode, this.bic, this.ibanLastChars, this.cardLastDigits);
        }
    }
}

