/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CapturePaymentInstruction;
import com.paypal.sdk.models.Money;

public class CaptureRequest {
    private String invoiceId;
    private String noteToPayer;
    private Money amount;
    private Boolean finalCapture;
    private CapturePaymentInstruction paymentInstruction;
    private String softDescriptor;

    public CaptureRequest() {
        this.finalCapture = false;
    }

    public CaptureRequest(String invoiceId, String noteToPayer, Money amount, Boolean finalCapture, CapturePaymentInstruction paymentInstruction, String softDescriptor) {
        this.invoiceId = invoiceId;
        this.noteToPayer = noteToPayer;
        this.amount = amount;
        this.finalCapture = finalCapture;
        this.paymentInstruction = paymentInstruction;
        this.softDescriptor = softDescriptor;
    }

    @JsonGetter(value="invoice_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonSetter(value="invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonGetter(value="note_to_payer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNoteToPayer() {
        return this.noteToPayer;
    }

    @JsonSetter(value="note_to_payer")
    public void setNoteToPayer(String noteToPayer) {
        this.noteToPayer = noteToPayer;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    @JsonGetter(value="final_capture")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getFinalCapture() {
        return this.finalCapture;
    }

    @JsonSetter(value="final_capture")
    public void setFinalCapture(Boolean finalCapture) {
        this.finalCapture = finalCapture;
    }

    @JsonGetter(value="payment_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CapturePaymentInstruction getPaymentInstruction() {
        return this.paymentInstruction;
    }

    @JsonSetter(value="payment_instruction")
    public void setPaymentInstruction(CapturePaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
    }

    @JsonGetter(value="soft_descriptor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSoftDescriptor() {
        return this.softDescriptor;
    }

    @JsonSetter(value="soft_descriptor")
    public void setSoftDescriptor(String softDescriptor) {
        this.softDescriptor = softDescriptor;
    }

    public String toString() {
        return "CaptureRequest [invoiceId=" + this.invoiceId + ", noteToPayer=" + this.noteToPayer + ", amount=" + this.amount + ", finalCapture=" + this.finalCapture + ", paymentInstruction=" + this.paymentInstruction + ", softDescriptor=" + this.softDescriptor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().invoiceId(this.getInvoiceId()).noteToPayer(this.getNoteToPayer()).amount(this.getAmount()).finalCapture(this.getFinalCapture()).paymentInstruction(this.getPaymentInstruction()).softDescriptor(this.getSoftDescriptor());
        return builder;
    }

    public static class Builder {
        private String invoiceId;
        private String noteToPayer;
        private Money amount;
        private Boolean finalCapture = false;
        private CapturePaymentInstruction paymentInstruction;
        private String softDescriptor;

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder noteToPayer(String noteToPayer) {
            this.noteToPayer = noteToPayer;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder finalCapture(Boolean finalCapture) {
            this.finalCapture = finalCapture;
            return this;
        }

        public Builder paymentInstruction(CapturePaymentInstruction paymentInstruction) {
            this.paymentInstruction = paymentInstruction;
            return this;
        }

        public Builder softDescriptor(String softDescriptor) {
            this.softDescriptor = softDescriptor;
            return this;
        }

        public CaptureRequest build() {
            return new CaptureRequest(this.invoiceId, this.noteToPayer, this.amount, this.finalCapture, this.paymentInstruction, this.softDescriptor);
        }
    }
}

