/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class ExchangeRate {
    private String sourceCurrency;
    private String targetCurrency;
    private String value;

    public ExchangeRate() {
    }

    public ExchangeRate(String sourceCurrency, String targetCurrency, String value) {
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.value = value;
    }

    @JsonGetter(value="source_currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonSetter(value="source_currency")
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    @JsonGetter(value="target_currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    @JsonSetter(value="target_currency")
    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    @JsonGetter(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValue() {
        return this.value;
    }

    @JsonSetter(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "ExchangeRate [sourceCurrency=" + this.sourceCurrency + ", targetCurrency=" + this.targetCurrency + ", value=" + this.value + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sourceCurrency(this.getSourceCurrency()).targetCurrency(this.getTargetCurrency()).value(this.getValue());
        return builder;
    }

    public static class Builder {
        private String sourceCurrency;
        private String targetCurrency;
        private String value;

        public Builder sourceCurrency(String sourceCurrency) {
            this.sourceCurrency = sourceCurrency;
            return this;
        }

        public Builder targetCurrency(String targetCurrency) {
            this.targetCurrency = targetCurrency;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public ExchangeRate build() {
            return new ExchangeRate(this.sourceCurrency, this.targetCurrency, this.value);
        }
    }
}

