/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ExchangeRate;
import com.paypal.sdk.models.Money;

public class NetAmountBreakdownItem {
    private Money payableAmount;
    private Money convertedAmount;
    private ExchangeRate exchangeRate;

    public NetAmountBreakdownItem() {
    }

    public NetAmountBreakdownItem(Money payableAmount, Money convertedAmount, ExchangeRate exchangeRate) {
        this.payableAmount = payableAmount;
        this.convertedAmount = convertedAmount;
        this.exchangeRate = exchangeRate;
    }

    @JsonGetter(value="payable_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPayableAmount() {
        return this.payableAmount;
    }

    @JsonSetter(value="payable_amount")
    public void setPayableAmount(Money payableAmount) {
        this.payableAmount = payableAmount;
    }

    @JsonGetter(value="converted_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getConvertedAmount() {
        return this.convertedAmount;
    }

    @JsonSetter(value="converted_amount")
    public void setConvertedAmount(Money convertedAmount) {
        this.convertedAmount = convertedAmount;
    }

    @JsonGetter(value="exchange_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExchangeRate getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonSetter(value="exchange_rate")
    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String toString() {
        return "NetAmountBreakdownItem [payableAmount=" + this.payableAmount + ", convertedAmount=" + this.convertedAmount + ", exchangeRate=" + this.exchangeRate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().payableAmount(this.getPayableAmount()).convertedAmount(this.getConvertedAmount()).exchangeRate(this.getExchangeRate());
        return builder;
    }

    public static class Builder {
        private Money payableAmount;
        private Money convertedAmount;
        private ExchangeRate exchangeRate;

        public Builder payableAmount(Money payableAmount) {
            this.payableAmount = payableAmount;
            return this;
        }

        public Builder convertedAmount(Money convertedAmount) {
            this.convertedAmount = convertedAmount;
            return this;
        }

        public Builder exchangeRate(ExchangeRate exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public NetAmountBreakdownItem build() {
            return new NetAmountBreakdownItem(this.payableAmount, this.convertedAmount, this.exchangeRate);
        }
    }
}

