/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderApplicationContextLandingPage;
import com.paypal.sdk.models.OrderApplicationContextShippingPreference;
import com.paypal.sdk.models.OrderApplicationContextUserAction;
import com.paypal.sdk.models.PaymentMethodPreference;
import com.paypal.sdk.models.StoredPaymentSource;

public class OrderApplicationContext {
    private String brandName;
    private String locale;
    private OrderApplicationContextLandingPage landingPage;
    private OrderApplicationContextShippingPreference shippingPreference;
    private OrderApplicationContextUserAction userAction;
    private PaymentMethodPreference paymentMethod;
    private String returnUrl;
    private String cancelUrl;
    private StoredPaymentSource storedPaymentSource;

    public OrderApplicationContext() {
        this.landingPage = OrderApplicationContextLandingPage.NO_PREFERENCE;
        this.shippingPreference = OrderApplicationContextShippingPreference.GET_FROM_FILE;
        this.userAction = OrderApplicationContextUserAction.CONTINUE;
    }

    public OrderApplicationContext(String brandName, String locale, OrderApplicationContextLandingPage landingPage, OrderApplicationContextShippingPreference shippingPreference, OrderApplicationContextUserAction userAction, PaymentMethodPreference paymentMethod, String returnUrl, String cancelUrl, StoredPaymentSource storedPaymentSource) {
        this.brandName = brandName;
        this.locale = locale;
        this.landingPage = landingPage;
        this.shippingPreference = shippingPreference;
        this.userAction = userAction;
        this.paymentMethod = paymentMethod;
        this.returnUrl = returnUrl;
        this.cancelUrl = cancelUrl;
        this.storedPaymentSource = storedPaymentSource;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="locale")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocale() {
        return this.locale;
    }

    @JsonSetter(value="locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @JsonGetter(value="landing_page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderApplicationContextLandingPage getLandingPage() {
        return this.landingPage;
    }

    @JsonSetter(value="landing_page")
    public void setLandingPage(OrderApplicationContextLandingPage landingPage) {
        this.landingPage = landingPage;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderApplicationContextShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(OrderApplicationContextShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="user_action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderApplicationContextUserAction getUserAction() {
        return this.userAction;
    }

    @JsonSetter(value="user_action")
    public void setUserAction(OrderApplicationContextUserAction userAction) {
        this.userAction = userAction;
    }

    @JsonGetter(value="payment_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentMethodPreference getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonSetter(value="payment_method")
    public void setPaymentMethod(PaymentMethodPreference paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @JsonGetter(value="return_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonSetter(value="return_url")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @JsonGetter(value="cancel_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @JsonSetter(value="cancel_url")
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @JsonGetter(value="stored_payment_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StoredPaymentSource getStoredPaymentSource() {
        return this.storedPaymentSource;
    }

    @JsonSetter(value="stored_payment_source")
    public void setStoredPaymentSource(StoredPaymentSource storedPaymentSource) {
        this.storedPaymentSource = storedPaymentSource;
    }

    public String toString() {
        return "OrderApplicationContext [brandName=" + this.brandName + ", locale=" + this.locale + ", landingPage=" + (Object)((Object)this.landingPage) + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", userAction=" + (Object)((Object)this.userAction) + ", paymentMethod=" + this.paymentMethod + ", returnUrl=" + this.returnUrl + ", cancelUrl=" + this.cancelUrl + ", storedPaymentSource=" + this.storedPaymentSource + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).locale(this.getLocale()).landingPage(this.getLandingPage()).shippingPreference(this.getShippingPreference()).userAction(this.getUserAction()).paymentMethod(this.getPaymentMethod()).returnUrl(this.getReturnUrl()).cancelUrl(this.getCancelUrl()).storedPaymentSource(this.getStoredPaymentSource());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private String locale;
        private OrderApplicationContextLandingPage landingPage = OrderApplicationContextLandingPage.NO_PREFERENCE;
        private OrderApplicationContextShippingPreference shippingPreference = OrderApplicationContextShippingPreference.GET_FROM_FILE;
        private OrderApplicationContextUserAction userAction = OrderApplicationContextUserAction.CONTINUE;
        private PaymentMethodPreference paymentMethod;
        private String returnUrl;
        private String cancelUrl;
        private StoredPaymentSource storedPaymentSource;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder landingPage(OrderApplicationContextLandingPage landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        public Builder shippingPreference(OrderApplicationContextShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder userAction(OrderApplicationContextUserAction userAction) {
            this.userAction = userAction;
            return this;
        }

        public Builder paymentMethod(PaymentMethodPreference paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder cancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder storedPaymentSource(StoredPaymentSource storedPaymentSource) {
            this.storedPaymentSource = storedPaymentSource;
            return this;
        }

        public OrderApplicationContext build() {
            return new OrderApplicationContext(this.brandName, this.locale, this.landingPage, this.shippingPreference, this.userAction, this.paymentMethod, this.returnUrl, this.cancelUrl, this.storedPaymentSource);
        }
    }
}

