/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PayeePaymentMethodPreference;
import com.paypal.sdk.models.StandardEntryClassCode;

public class PaymentMethodPreference {
    private PayeePaymentMethodPreference payeePreferred;
    private StandardEntryClassCode standardEntryClassCode;

    public PaymentMethodPreference() {
        this.payeePreferred = PayeePaymentMethodPreference.UNRESTRICTED;
        this.standardEntryClassCode = StandardEntryClassCode.WEB;
    }

    public PaymentMethodPreference(PayeePaymentMethodPreference payeePreferred, StandardEntryClassCode standardEntryClassCode) {
        this.payeePreferred = payeePreferred;
        this.standardEntryClassCode = standardEntryClassCode;
    }

    @JsonGetter(value="payee_preferred")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayeePaymentMethodPreference getPayeePreferred() {
        return this.payeePreferred;
    }

    @JsonSetter(value="payee_preferred")
    public void setPayeePreferred(PayeePaymentMethodPreference payeePreferred) {
        this.payeePreferred = payeePreferred;
    }

    @JsonGetter(value="standard_entry_class_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StandardEntryClassCode getStandardEntryClassCode() {
        return this.standardEntryClassCode;
    }

    @JsonSetter(value="standard_entry_class_code")
    public void setStandardEntryClassCode(StandardEntryClassCode standardEntryClassCode) {
        this.standardEntryClassCode = standardEntryClassCode;
    }

    public String toString() {
        return "PaymentMethodPreference [payeePreferred=" + (Object)((Object)this.payeePreferred) + ", standardEntryClassCode=" + (Object)((Object)this.standardEntryClassCode) + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().payeePreferred(this.getPayeePreferred()).standardEntryClassCode(this.getStandardEntryClassCode());
        return builder;
    }

    public static class Builder {
        private PayeePaymentMethodPreference payeePreferred = PayeePaymentMethodPreference.UNRESTRICTED;
        private StandardEntryClassCode standardEntryClassCode = StandardEntryClassCode.WEB;

        public Builder payeePreferred(PayeePaymentMethodPreference payeePreferred) {
            this.payeePreferred = payeePreferred;
            return this;
        }

        public Builder standardEntryClassCode(StandardEntryClassCode standardEntryClassCode) {
            this.standardEntryClassCode = standardEntryClassCode;
            return this;
        }

        public PaymentMethodPreference build() {
            return new PaymentMethodPreference(this.payeePreferred, this.standardEntryClassCode);
        }
    }
}

