/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.BillingCycle;
import com.paypal.sdk.models.OneTimeCharge;
import com.paypal.sdk.utilities.JsonValue;
import java.util.List;

public class Plan {
    private List<BillingCycle> billingCycles;
    private JsonValue product;
    private OneTimeCharge oneTimeCharges;
    private String name;

    public Plan() {
    }

    public Plan(List<BillingCycle> billingCycles, OneTimeCharge oneTimeCharges, JsonValue product, String name) {
        this.billingCycles = billingCycles;
        this.product = product;
        this.oneTimeCharges = oneTimeCharges;
        this.name = name;
    }

    @JsonGetter(value="billing_cycles")
    public List<BillingCycle> getBillingCycles() {
        return this.billingCycles;
    }

    @JsonSetter(value="billing_cycles")
    public void setBillingCycles(List<BillingCycle> billingCycles) {
        this.billingCycles = billingCycles;
    }

    @JsonGetter(value="product")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonValue getProduct() {
        return this.product;
    }

    @JsonSetter(value="product")
    public void setProduct(JsonValue product) {
        this.product = product;
    }

    @JsonGetter(value="one_time_charges")
    public OneTimeCharge getOneTimeCharges() {
        return this.oneTimeCharges;
    }

    @JsonSetter(value="one_time_charges")
    public void setOneTimeCharges(OneTimeCharge oneTimeCharges) {
        this.oneTimeCharges = oneTimeCharges;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Plan [billingCycles=" + this.billingCycles + ", oneTimeCharges=" + this.oneTimeCharges + ", product=" + (Object)((Object)this.product) + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.billingCycles, this.oneTimeCharges).product(this.getProduct()).name(this.getName());
        return builder;
    }

    public static class Builder {
        private List<BillingCycle> billingCycles;
        private OneTimeCharge oneTimeCharges;
        private JsonValue product;
        private String name;

        public Builder() {
        }

        public Builder(List<BillingCycle> billingCycles, OneTimeCharge oneTimeCharges) {
            this.billingCycles = billingCycles;
            this.oneTimeCharges = oneTimeCharges;
        }

        public Builder billingCycles(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
            return this;
        }

        public Builder oneTimeCharges(OneTimeCharge oneTimeCharges) {
            this.oneTimeCharges = oneTimeCharges;
            return this;
        }

        public Builder product(JsonValue product) {
            this.product = product;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Plan build() {
            return new Plan(this.billingCycles, this.oneTimeCharges, this.product, this.name);
        }
    }
}

