/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ReauthorizeRequest;

public class ReauthorizePaymentInput {
    private String authorizationId;
    private String contentType;
    private String paypalRequestId;
    private String prefer;
    private String paypalAuthAssertion;
    private ReauthorizeRequest body;

    public ReauthorizePaymentInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public ReauthorizePaymentInput(String authorizationId, String contentType, String paypalRequestId, String prefer, String paypalAuthAssertion, ReauthorizeRequest body) {
        this.authorizationId = authorizationId;
        this.contentType = contentType;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReauthorizeRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(ReauthorizeRequest body) {
        this.body = body;
    }

    public String toString() {
        return "ReauthorizePaymentInput [authorizationId=" + this.authorizationId + ", contentType=" + this.contentType + ", paypalRequestId=" + this.paypalRequestId + ", prefer=" + this.prefer + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId, this.contentType).paypalRequestId(this.getPaypalRequestId()).prefer(this.getPrefer()).paypalAuthAssertion(this.getPaypalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String contentType = "application/json";
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;
        private ReauthorizeRequest body;

        public Builder() {
        }

        public Builder(String authorizationId, String contentType) {
            this.authorizationId = authorizationId;
            this.contentType = contentType;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder body(ReauthorizeRequest body) {
            this.body = body;
            return this;
        }

        public ReauthorizePaymentInput build() {
            return new ReauthorizePaymentInput(this.authorizationId, this.contentType, this.paypalRequestId, this.prefer, this.paypalAuthAssertion, this.body);
        }
    }
}

