/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ApplePayPaymentData type.
 */
public class ApplePayPaymentData {
    private String cryptogram;
    private String eciIndicator;
    private String emvData;
    private String pin;

    /**
     * Default constructor.
     */
    public ApplePayPaymentData() {
    }

    /**
     * Initialization constructor.
     * @param  cryptogram  String value for cryptogram.
     * @param  eciIndicator  String value for eciIndicator.
     * @param  emvData  String value for emvData.
     * @param  pin  String value for pin.
     */
    public ApplePayPaymentData(
            String cryptogram,
            String eciIndicator,
            String emvData,
            String pin) {
        this.cryptogram = cryptogram;
        this.eciIndicator = eciIndicator;
        this.emvData = emvData;
        this.pin = pin;
    }

    /**
     * Getter for Cryptogram.
     * Online payment cryptogram, as defined by 3D Secure. The pattern is defined by an external
     * party and supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("cryptogram")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCryptogram() {
        return cryptogram;
    }

    /**
     * Setter for Cryptogram.
     * Online payment cryptogram, as defined by 3D Secure. The pattern is defined by an external
     * party and supports Unicode.
     * @param cryptogram Value for String
     */
    @JsonSetter("cryptogram")
    public void setCryptogram(String cryptogram) {
        this.cryptogram = cryptogram;
    }

    /**
     * Getter for EciIndicator.
     * ECI indicator, as defined by 3- Secure. The pattern is defined by an external party and
     * supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("eci_indicator")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEciIndicator() {
        return eciIndicator;
    }

    /**
     * Setter for EciIndicator.
     * ECI indicator, as defined by 3- Secure. The pattern is defined by an external party and
     * supports Unicode.
     * @param eciIndicator Value for String
     */
    @JsonSetter("eci_indicator")
    public void setEciIndicator(String eciIndicator) {
        this.eciIndicator = eciIndicator;
    }

    /**
     * Getter for EmvData.
     * Encoded Apple Pay EMV Payment Structure used for payments in China. The pattern is defined by
     * an external party and supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("emv_data")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmvData() {
        return emvData;
    }

    /**
     * Setter for EmvData.
     * Encoded Apple Pay EMV Payment Structure used for payments in China. The pattern is defined by
     * an external party and supports Unicode.
     * @param emvData Value for String
     */
    @JsonSetter("emv_data")
    public void setEmvData(String emvData) {
        this.emvData = emvData;
    }

    /**
     * Getter for Pin.
     * Bank Key encrypted Apple Pay PIN. The pattern is defined by an external party and supports
     * Unicode.
     * @return Returns the String
     */
    @JsonGetter("pin")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPin() {
        return pin;
    }

    /**
     * Setter for Pin.
     * Bank Key encrypted Apple Pay PIN. The pattern is defined by an external party and supports
     * Unicode.
     * @param pin Value for String
     */
    @JsonSetter("pin")
    public void setPin(String pin) {
        this.pin = pin;
    }

    /**
     * Converts this ApplePayPaymentData into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ApplePayPaymentData [" + "cryptogram=" + cryptogram + ", eciIndicator="
                + eciIndicator + ", emvData=" + emvData + ", pin=" + pin + "]";
    }

    /**
     * Builds a new {@link ApplePayPaymentData.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ApplePayPaymentData.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .cryptogram(getCryptogram())
                .eciIndicator(getEciIndicator())
                .emvData(getEmvData())
                .pin(getPin());
        return builder;
    }

    /**
     * Class to build instances of {@link ApplePayPaymentData}.
     */
    public static class Builder {
        private String cryptogram;
        private String eciIndicator;
        private String emvData;
        private String pin;



        /**
         * Setter for cryptogram.
         * @param  cryptogram  String value for cryptogram.
         * @return Builder
         */
        public Builder cryptogram(String cryptogram) {
            this.cryptogram = cryptogram;
            return this;
        }

        /**
         * Setter for eciIndicator.
         * @param  eciIndicator  String value for eciIndicator.
         * @return Builder
         */
        public Builder eciIndicator(String eciIndicator) {
            this.eciIndicator = eciIndicator;
            return this;
        }

        /**
         * Setter for emvData.
         * @param  emvData  String value for emvData.
         * @return Builder
         */
        public Builder emvData(String emvData) {
            this.emvData = emvData;
            return this;
        }

        /**
         * Setter for pin.
         * @param  pin  String value for pin.
         * @return Builder
         */
        public Builder pin(String pin) {
            this.pin = pin;
            return this;
        }

        /**
         * Builds a new {@link ApplePayPaymentData} object using the set fields.
         * @return {@link ApplePayPaymentData}
         */
        public ApplePayPaymentData build() {
            return new ApplePayPaymentData(cryptogram, eciIndicator, emvData, pin);
        }
    }
}
