/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for ApplePayRequest type.
 */
public class ApplePayRequest {
    private String id;
    private String name;
    private String emailAddress;
    private PhoneNumber phoneNumber;
    private ApplePayDecryptedTokenData decryptedToken;
    private CardStoredCredential storedCredential;
    private String vaultId;
    private ApplePayAttributes attributes;
    private ApplePayExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public ApplePayRequest() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  name  String value for name.
     * @param  emailAddress  String value for emailAddress.
     * @param  phoneNumber  PhoneNumber value for phoneNumber.
     * @param  decryptedToken  ApplePayDecryptedTokenData value for decryptedToken.
     * @param  storedCredential  CardStoredCredential value for storedCredential.
     * @param  vaultId  String value for vaultId.
     * @param  attributes  ApplePayAttributes value for attributes.
     * @param  experienceContext  ApplePayExperienceContext value for experienceContext.
     */
    public ApplePayRequest(
            String id,
            String name,
            String emailAddress,
            PhoneNumber phoneNumber,
            ApplePayDecryptedTokenData decryptedToken,
            CardStoredCredential storedCredential,
            String vaultId,
            ApplePayAttributes attributes,
            ApplePayExperienceContext experienceContext) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.decryptedToken = decryptedToken;
        this.storedCredential = storedCredential;
        this.vaultId = vaultId;
        this.attributes = attributes;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Id.
     * ApplePay transaction identifier, this will be the unique identifier for this transaction
     * provided by Apple. The pattern is defined by an external party and supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * ApplePay transaction identifier, this will be the unique identifier for this transaction
     * provided by Apple. The pattern is defined by an external party and supports Unicode.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumber
     */
    @JsonGetter("phone_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumber
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for DecryptedToken.
     * Information about the Payment data obtained by decrypting Apple Pay token.
     * @return Returns the ApplePayDecryptedTokenData
     */
    @JsonGetter("decrypted_token")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ApplePayDecryptedTokenData getDecryptedToken() {
        return decryptedToken;
    }

    /**
     * Setter for DecryptedToken.
     * Information about the Payment data obtained by decrypting Apple Pay token.
     * @param decryptedToken Value for ApplePayDecryptedTokenData
     */
    @JsonSetter("decrypted_token")
    public void setDecryptedToken(ApplePayDecryptedTokenData decryptedToken) {
        this.decryptedToken = decryptedToken;
    }

    /**
     * Getter for StoredCredential.
     * Provides additional details to process a payment using a `card` that has been stored or is
     * intended to be stored (also referred to as stored_credential or card-on-file). Parameter
     * compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`. Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be
     * present in the request.
     * @return Returns the CardStoredCredential
     */
    @JsonGetter("stored_credential")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardStoredCredential getStoredCredential() {
        return storedCredential;
    }

    /**
     * Setter for StoredCredential.
     * Provides additional details to process a payment using a `card` that has been stored or is
     * intended to be stored (also referred to as stored_credential or card-on-file). Parameter
     * compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`. Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be
     * present in the request.
     * @param storedCredential Value for CardStoredCredential
     */
    @JsonSetter("stored_credential")
    public void setStoredCredential(CardStoredCredential storedCredential) {
        this.storedCredential = storedCredential;
    }

    /**
     * Getter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @return Returns the String
     */
    @JsonGetter("vault_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getVaultId() {
        return vaultId;
    }

    /**
     * Setter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @param vaultId Value for String
     */
    @JsonSetter("vault_id")
    public void setVaultId(String vaultId) {
        this.vaultId = vaultId;
    }

    /**
     * Getter for Attributes.
     * Additional attributes associated with apple pay.
     * @return Returns the ApplePayAttributes
     */
    @JsonGetter("attributes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ApplePayAttributes getAttributes() {
        return attributes;
    }

    /**
     * Setter for Attributes.
     * Additional attributes associated with apple pay.
     * @param attributes Value for ApplePayAttributes
     */
    @JsonSetter("attributes")
    public void setAttributes(ApplePayAttributes attributes) {
        this.attributes = attributes;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @return Returns the ApplePayExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ApplePayExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the payer experience during the approval process for the payment.
     * @param experienceContext Value for ApplePayExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(ApplePayExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this ApplePayRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ApplePayRequest [" + "id=" + id + ", name=" + name + ", emailAddress="
                + emailAddress + ", phoneNumber=" + phoneNumber + ", decryptedToken="
                + decryptedToken + ", storedCredential=" + storedCredential + ", vaultId=" + vaultId
                + ", attributes=" + attributes + ", experienceContext=" + experienceContext + "]";
    }

    /**
     * Builds a new {@link ApplePayRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link ApplePayRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .name(getName())
                .emailAddress(getEmailAddress())
                .phoneNumber(getPhoneNumber())
                .decryptedToken(getDecryptedToken())
                .storedCredential(getStoredCredential())
                .vaultId(getVaultId())
                .attributes(getAttributes())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link ApplePayRequest}.
     */
    public static class Builder {
        private String id;
        private String name;
        private String emailAddress;
        private PhoneNumber phoneNumber;
        private ApplePayDecryptedTokenData decryptedToken;
        private CardStoredCredential storedCredential;
        private String vaultId;
        private ApplePayAttributes attributes;
        private ApplePayExperienceContext experienceContext;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumber value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for decryptedToken.
         * @param  decryptedToken  ApplePayDecryptedTokenData value for decryptedToken.
         * @return Builder
         */
        public Builder decryptedToken(ApplePayDecryptedTokenData decryptedToken) {
            this.decryptedToken = decryptedToken;
            return this;
        }

        /**
         * Setter for storedCredential.
         * @param  storedCredential  CardStoredCredential value for storedCredential.
         * @return Builder
         */
        public Builder storedCredential(CardStoredCredential storedCredential) {
            this.storedCredential = storedCredential;
            return this;
        }

        /**
         * Setter for vaultId.
         * @param  vaultId  String value for vaultId.
         * @return Builder
         */
        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        /**
         * Setter for attributes.
         * @param  attributes  ApplePayAttributes value for attributes.
         * @return Builder
         */
        public Builder attributes(ApplePayAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  ApplePayExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(ApplePayExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link ApplePayRequest} object using the set fields.
         * @return {@link ApplePayRequest}
         */
        public ApplePayRequest build() {
            return new ApplePayRequest(id, name, emailAddress, phoneNumber, decryptedToken,
                    storedCredential, vaultId, attributes, experienceContext);
        }
    }
}
