/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.utilities.JsonValue;

/**
 * This is a model class for CardVerificationDetails type.
 */
public class CardVerificationDetails {
    private String networkTransactionId;
    private String date;
    private CardBrand network;
    private String time;
    private Money amount;
    private CardVerificationProcessorResponse processorResponse;
    private JsonValue threeDSecure;

    /**
     * Default constructor.
     */
    public CardVerificationDetails() {
    }

    /**
     * Initialization constructor.
     * @param  networkTransactionId  String value for networkTransactionId.
     * @param  date  String value for date.
     * @param  network  CardBrand value for network.
     * @param  time  String value for time.
     * @param  amount  Money value for amount.
     * @param  processorResponse  CardVerificationProcessorResponse value for processorResponse.
     * @param  threeDSecure  JsonValue value for threeDSecure.
     */
    public CardVerificationDetails(
            String networkTransactionId,
            String date,
            CardBrand network,
            String time,
            Money amount,
            CardVerificationProcessorResponse processorResponse,
            JsonValue threeDSecure) {
        this.networkTransactionId = networkTransactionId;
        this.date = date;
        this.network = network;
        this.time = time;
        this.amount = amount;
        this.processorResponse = processorResponse;
        this.threeDSecure = threeDSecure;
    }

    /**
     * Getter for NetworkTransactionId.
     * DEPRECATED. This field is DEPRECATED. Please find the network transaction id data in the 'id'
     * field under the 'network_transaction_reference' object instead of the 'verification' object.
     * @return Returns the String
     */
    @JsonGetter("network_transaction_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getNetworkTransactionId() {
        return networkTransactionId;
    }

    /**
     * Setter for NetworkTransactionId.
     * DEPRECATED. This field is DEPRECATED. Please find the network transaction id data in the 'id'
     * field under the 'network_transaction_reference' object instead of the 'verification' object.
     * @param networkTransactionId Value for String
     */
    @JsonSetter("network_transaction_id")
    public void setNetworkTransactionId(String networkTransactionId) {
        this.networkTransactionId = networkTransactionId;
    }

    /**
     * Getter for Date.
     * DEPRECATED. This field is DEPRECATED. Please find the date data in the 'date' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     * @return Returns the String
     */
    @JsonGetter("date")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDate() {
        return date;
    }

    /**
     * Setter for Date.
     * DEPRECATED. This field is DEPRECATED. Please find the date data in the 'date' field under the
     * 'network_transaction_reference' object instead of the 'verification' object.
     * @param date Value for String
     */
    @JsonSetter("date")
    public void setDate(String date) {
        this.date = date;
    }

    /**
     * Getter for Network.
     * The card network or brand. Applies to credit, debit, gift, and payment cards.
     * @return Returns the CardBrand
     */
    @JsonGetter("network")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardBrand getNetwork() {
        return network;
    }

    /**
     * Setter for Network.
     * The card network or brand. Applies to credit, debit, gift, and payment cards.
     * @param network Value for CardBrand
     */
    @JsonSetter("network")
    public void setNetwork(CardBrand network) {
        this.network = network;
    }

    /**
     * Getter for Time.
     * The date and time, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds are required while
     * fractional seconds are optional. Note: The regular expression provides guidance but does not
     * reject all invalid dates.
     * @return Returns the String
     */
    @JsonGetter("time")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getTime() {
        return time;
    }

    /**
     * Setter for Time.
     * The date and time, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds are required while
     * fractional seconds are optional. Note: The regular expression provides guidance but does not
     * reject all invalid dates.
     * @param time Value for String
     */
    @JsonSetter("time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * Getter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param amount Value for Money
     */
    @JsonSetter("amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    /**
     * Getter for ProcessorResponse.
     * The processor response information for payment requests, such as direct credit card
     * transactions.
     * @return Returns the CardVerificationProcessorResponse
     */
    @JsonGetter("processor_response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardVerificationProcessorResponse getProcessorResponse() {
        return processorResponse;
    }

    /**
     * Setter for ProcessorResponse.
     * The processor response information for payment requests, such as direct credit card
     * transactions.
     * @param processorResponse Value for CardVerificationProcessorResponse
     */
    @JsonSetter("processor_response")
    public void setProcessorResponse(CardVerificationProcessorResponse processorResponse) {
        this.processorResponse = processorResponse;
    }

    /**
     * Getter for ThreeDSecure.
     * DEPRECATED. This field is DEPRECATED. Please find the 3D secure authentication data in the
     * 'three_d_secure' object under the 'authentication_result' object instead of the
     * 'verification' object.
     * @return Returns the JsonValue
     */
    @JsonGetter("three_d_secure")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public JsonValue getThreeDSecure() {
        return threeDSecure;
    }

    /**
     * Setter for ThreeDSecure.
     * DEPRECATED. This field is DEPRECATED. Please find the 3D secure authentication data in the
     * 'three_d_secure' object under the 'authentication_result' object instead of the
     * 'verification' object.
     * @param threeDSecure Value for JsonValue
     */
    @JsonSetter("three_d_secure")
    public void setThreeDSecure(JsonValue threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    /**
     * Converts this CardVerificationDetails into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CardVerificationDetails [" + "networkTransactionId=" + networkTransactionId
                + ", date=" + date + ", network=" + network + ", time=" + time + ", amount="
                + amount + ", processorResponse=" + processorResponse + ", threeDSecure="
                + threeDSecure + "]";
    }

    /**
     * Builds a new {@link CardVerificationDetails.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CardVerificationDetails.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .networkTransactionId(getNetworkTransactionId())
                .date(getDate())
                .network(getNetwork())
                .time(getTime())
                .amount(getAmount())
                .processorResponse(getProcessorResponse())
                .threeDSecure(getThreeDSecure());
        return builder;
    }

    /**
     * Class to build instances of {@link CardVerificationDetails}.
     */
    public static class Builder {
        private String networkTransactionId;
        private String date;
        private CardBrand network;
        private String time;
        private Money amount;
        private CardVerificationProcessorResponse processorResponse;
        private JsonValue threeDSecure;



        /**
         * Setter for networkTransactionId.
         * @param  networkTransactionId  String value for networkTransactionId.
         * @return Builder
         */
        public Builder networkTransactionId(String networkTransactionId) {
            this.networkTransactionId = networkTransactionId;
            return this;
        }

        /**
         * Setter for date.
         * @param  date  String value for date.
         * @return Builder
         */
        public Builder date(String date) {
            this.date = date;
            return this;
        }

        /**
         * Setter for network.
         * @param  network  CardBrand value for network.
         * @return Builder
         */
        public Builder network(CardBrand network) {
            this.network = network;
            return this;
        }

        /**
         * Setter for time.
         * @param  time  String value for time.
         * @return Builder
         */
        public Builder time(String time) {
            this.time = time;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  Money value for amount.
         * @return Builder
         */
        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Setter for processorResponse.
         * @param  processorResponse  CardVerificationProcessorResponse value for processorResponse.
         * @return Builder
         */
        public Builder processorResponse(CardVerificationProcessorResponse processorResponse) {
            this.processorResponse = processorResponse;
            return this;
        }

        /**
         * Setter for threeDSecure.
         * @param  threeDSecure  JsonValue value for threeDSecure.
         * @return Builder
         */
        public Builder threeDSecure(JsonValue threeDSecure) {
            this.threeDSecure = threeDSecure;
            return this;
        }

        /**
         * Builds a new {@link CardVerificationDetails} object using the set fields.
         * @return {@link CardVerificationDetails}
         */
        public CardVerificationDetails build() {
            return new CardVerificationDetails(networkTransactionId, date, network, time, amount,
                    processorResponse, threeDSecure);
        }
    }
}
