/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CreateOrderTrackingInput type.
 */
public class CreateOrderTrackingInput {
    private String id;
    private String contentType;
    private OrderTrackerRequest body;
    private String paypalAuthAssertion;

    /**
     * Default constructor.
     */
    public CreateOrderTrackingInput() {
        contentType = "application/json";
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  contentType  String value for contentType.
     * @param  body  OrderTrackerRequest value for body.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     */
    public CreateOrderTrackingInput(
            String id,
            String contentType,
            OrderTrackerRequest body,
            String paypalAuthAssertion) {
        this.id = id;
        this.contentType = contentType;
        this.body = body;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Id.
     * The ID of the order that the tracking information is associated with.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order that the tracking information is associated with.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for Body.
     * @return Returns the OrderTrackerRequest
     */
    @JsonGetter("body")
    public OrderTrackerRequest getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for OrderTrackerRequest
     */
    @JsonSetter("body")
    public void setBody(OrderTrackerRequest body) {
        this.body = body;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Converts this CreateOrderTrackingInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CreateOrderTrackingInput [" + "id=" + id + ", contentType=" + contentType
                + ", body=" + body + ", paypalAuthAssertion=" + paypalAuthAssertion + "]";
    }

    /**
     * Builds a new {@link CreateOrderTrackingInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CreateOrderTrackingInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, contentType, body)
                .paypalAuthAssertion(getPaypalAuthAssertion());
        return builder;
    }

    /**
     * Class to build instances of {@link CreateOrderTrackingInput}.
     */
    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private OrderTrackerRequest body;
        private String paypalAuthAssertion;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  contentType  String value for contentType.
         * @param  body  OrderTrackerRequest value for body.
         */
        public Builder(String id, String contentType, OrderTrackerRequest body) {
            this.id = id;
            this.contentType = contentType;
            this.body = body;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  OrderTrackerRequest value for body.
         * @return Builder
         */
        public Builder body(OrderTrackerRequest body) {
            this.body = body;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Builds a new {@link CreateOrderTrackingInput} object using the set fields.
         * @return {@link CreateOrderTrackingInput}
         */
        public CreateOrderTrackingInput build() {
            return new CreateOrderTrackingInput(id, contentType, body, paypalAuthAssertion);
        }
    }
}
