/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for OrderUpdateCallbackShippingAddress type.
 */
public class OrderUpdateCallbackShippingAddress {
    private String adminArea2;
    private String adminArea1;
    private String postalCode;
    private String countryCode;

    /**
     * Default constructor.
     */
    public OrderUpdateCallbackShippingAddress() {
    }

    /**
     * Initialization constructor.
     * @param  countryCode  String value for countryCode.
     * @param  adminArea2  String value for adminArea2.
     * @param  adminArea1  String value for adminArea1.
     * @param  postalCode  String value for postalCode.
     */
    public OrderUpdateCallbackShippingAddress(
            String countryCode,
            String adminArea2,
            String adminArea1,
            String postalCode) {
        this.adminArea2 = adminArea2;
        this.adminArea1 = adminArea1;
        this.postalCode = postalCode;
        this.countryCode = countryCode;
    }

    /**
     * Getter for AdminArea2.
     * A city, town, or village. Smaller than `admin_area_level_1`.
     * @return Returns the String
     */
    @JsonGetter("admin_area_2")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAdminArea2() {
        return adminArea2;
    }

    /**
     * Setter for AdminArea2.
     * A city, town, or village. Smaller than `admin_area_level_1`.
     * @param adminArea2 Value for String
     */
    @JsonSetter("admin_area_2")
    public void setAdminArea2(String adminArea2) {
        this.adminArea2 = adminArea2;
    }

    /**
     * Getter for AdminArea1.
     * The highest-level sub-division in a country, which is usually a province, state, or
     * ISO-3166-2 subdivision. This data is formatted for postal delivery, for example, `CA` and not
     * `California`. Value, by country, is: UK. A county. US. A state. Canada. A province. Japan. A
     * prefecture. Switzerland. A *kanton*.
     * @return Returns the String
     */
    @JsonGetter("admin_area_1")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAdminArea1() {
        return adminArea1;
    }

    /**
     * Setter for AdminArea1.
     * The highest-level sub-division in a country, which is usually a province, state, or
     * ISO-3166-2 subdivision. This data is formatted for postal delivery, for example, `CA` and not
     * `California`. Value, by country, is: UK. A county. US. A state. Canada. A province. Japan. A
     * prefecture. Switzerland. A *kanton*.
     * @param adminArea1 Value for String
     */
    @JsonSetter("admin_area_1")
    public void setAdminArea1(String adminArea1) {
        this.adminArea1 = adminArea1;
    }

    /**
     * Getter for PostalCode.
     * The postal code, which is the ZIP code or equivalent. Typically required for countries with a
     * postal code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     * @return Returns the String
     */
    @JsonGetter("postal_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPostalCode() {
        return postalCode;
    }

    /**
     * Setter for PostalCode.
     * The postal code, which is the ZIP code or equivalent. Typically required for countries with a
     * postal code or an equivalent. See [postal code](https://en.wikipedia.org/wiki/Postal_code).
     * @param postalCode Value for String
     */
    @JsonSetter("postal_code")
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /**
     * Getter for CountryCode.
     * The [2-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [2-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Converts this OrderUpdateCallbackShippingAddress into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderUpdateCallbackShippingAddress [" + "countryCode=" + countryCode
                + ", adminArea2=" + adminArea2 + ", adminArea1=" + adminArea1 + ", postalCode="
                + postalCode + "]";
    }

    /**
     * Builds a new {@link OrderUpdateCallbackShippingAddress.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderUpdateCallbackShippingAddress.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(countryCode)
                .adminArea2(getAdminArea2())
                .adminArea1(getAdminArea1())
                .postalCode(getPostalCode());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderUpdateCallbackShippingAddress}.
     */
    public static class Builder {
        private String countryCode;
        private String adminArea2;
        private String adminArea1;
        private String postalCode;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  countryCode  String value for countryCode.
         */
        public Builder(String countryCode) {
            this.countryCode = countryCode;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for adminArea2.
         * @param  adminArea2  String value for adminArea2.
         * @return Builder
         */
        public Builder adminArea2(String adminArea2) {
            this.adminArea2 = adminArea2;
            return this;
        }

        /**
         * Setter for adminArea1.
         * @param  adminArea1  String value for adminArea1.
         * @return Builder
         */
        public Builder adminArea1(String adminArea1) {
            this.adminArea1 = adminArea1;
            return this;
        }

        /**
         * Setter for postalCode.
         * @param  postalCode  String value for postalCode.
         * @return Builder
         */
        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        /**
         * Builds a new {@link OrderUpdateCallbackShippingAddress} object using the set fields.
         * @return {@link OrderUpdateCallbackShippingAddress}
         */
        public OrderUpdateCallbackShippingAddress build() {
            return new OrderUpdateCallbackShippingAddress(countryCode, adminArea2, adminArea1,
                    postalCode);
        }
    }
}
