/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PaResStatus to be used.
 */
public enum PaResStatus {
    /**
     * Successful authentication.
     */
    SUCCESSFULAUTHENTICATION,

    /**
     * Failed authentication / account not verified / transaction denied.
     */
    FAILEDAUTHENTICATION,

    /**
     * Unable to complete authentication.
     */
    UNABLETOCOMPLETEAUTHENTICATION,

    /**
     * Successful attempts transaction.
     */
    SUCCESSFULATTEMPTSTRANSACTION,

    /**
     * Challenge required for authentication.
     */
    CHALLENGEREQUIRED,

    /**
     * Authentication rejected (merchant must not submit for authorization).
     */
    AUTHENTICATIONREJECTED,

    /**
     * Challenge required; decoupled authentication confirmed.
     */
    DECOUPLEDAUTHENTICATION,

    /**
     * Informational only; 3DS requestor challenge preference acknowledged.
     */
    INFORMATIONALONLY,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PaResStatus> valueMap = new TreeMap<>();
    private String value;

    static {
        SUCCESSFULAUTHENTICATION.value = "Y";
        FAILEDAUTHENTICATION.value = "N";
        UNABLETOCOMPLETEAUTHENTICATION.value = "U";
        SUCCESSFULATTEMPTSTRANSACTION.value = "A";
        CHALLENGEREQUIRED.value = "C";
        AUTHENTICATIONREJECTED.value = "R";
        DECOUPLEDAUTHENTICATION.value = "D";
        INFORMATIONALONLY.value = "I";
        _UNKNOWN.value = null;

        valueMap.put("Y", SUCCESSFULAUTHENTICATION);
        valueMap.put("N", FAILEDAUTHENTICATION);
        valueMap.put("U", UNABLETOCOMPLETEAUTHENTICATION);
        valueMap.put("A", SUCCESSFULATTEMPTSTRANSACTION);
        valueMap.put("C", CHALLENGEREQUIRED);
        valueMap.put("R", AUTHENTICATIONREJECTED);
        valueMap.put("D", DECOUPLEDAUTHENTICATION);
        valueMap.put("I", INFORMATIONALONLY);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PaResStatus constructFromString(String toConvert) throws IOException {
        PaResStatus enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PaResStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PaResStatus values to list of string values.
     * @param toConvert The list of PaResStatus values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PaResStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PaResStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 