/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PaypalWalletExperienceContext type.
 */
public class PaypalWalletExperienceContext {
    private String brandName;
    private String locale;
    private PaypalWalletContextShippingPreference shippingPreference;
    private PaypalWalletContactPreference contactPreference;
    private String returnUrl;
    private String cancelUrl;
    private PaypalExperienceLandingPage landingPage;
    private PaypalExperienceUserAction userAction;
    private PayeePaymentMethodPreference paymentMethodPreference;
    private CallbackConfiguration orderUpdateCallbackConfig;

    /**
     * Default constructor.
     */
    public PaypalWalletExperienceContext() {
        shippingPreference = PaypalWalletContextShippingPreference.GET_FROM_FILE;
        contactPreference = PaypalWalletContactPreference.NO_CONTACT_INFO;
        landingPage = PaypalExperienceLandingPage.NO_PREFERENCE;
        userAction = PaypalExperienceUserAction.CONTINUE;
        paymentMethodPreference = PayeePaymentMethodPreference.UNRESTRICTED;
    }

    /**
     * Initialization constructor.
     * @param  brandName  String value for brandName.
     * @param  locale  String value for locale.
     * @param  shippingPreference  PaypalWalletContextShippingPreference value for
     *         shippingPreference.
     * @param  contactPreference  PaypalWalletContactPreference value for contactPreference.
     * @param  returnUrl  String value for returnUrl.
     * @param  cancelUrl  String value for cancelUrl.
     * @param  landingPage  PaypalExperienceLandingPage value for landingPage.
     * @param  userAction  PaypalExperienceUserAction value for userAction.
     * @param  paymentMethodPreference  PayeePaymentMethodPreference value for
     *         paymentMethodPreference.
     * @param  orderUpdateCallbackConfig  CallbackConfiguration value for orderUpdateCallbackConfig.
     */
    public PaypalWalletExperienceContext(
            String brandName,
            String locale,
            PaypalWalletContextShippingPreference shippingPreference,
            PaypalWalletContactPreference contactPreference,
            String returnUrl,
            String cancelUrl,
            PaypalExperienceLandingPage landingPage,
            PaypalExperienceUserAction userAction,
            PayeePaymentMethodPreference paymentMethodPreference,
            CallbackConfiguration orderUpdateCallbackConfig) {
        this.brandName = brandName;
        this.locale = locale;
        this.shippingPreference = shippingPreference;
        this.contactPreference = contactPreference;
        this.returnUrl = returnUrl;
        this.cancelUrl = cancelUrl;
        this.landingPage = landingPage;
        this.userAction = userAction;
        this.paymentMethodPreference = paymentMethodPreference;
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    /**
     * Getter for BrandName.
     * The label that overrides the business name in the PayPal account on the PayPal site. The
     * pattern is defined by an external party and supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("brand_name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return brandName;
    }

    /**
     * Setter for BrandName.
     * The label that overrides the business name in the PayPal account on the PayPal site. The
     * pattern is defined by an external party and supports Unicode.
     * @param brandName Value for String
     */
    @JsonSetter("brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * Getter for Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag
     * is made up of the [ISO 639-2 language
     * code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924
     * script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2
     * country code](/api/rest/reference/country-codes/) or [M49 region
     * code](https://unstats.un.org/unsd/methodology/m49/).
     * @return Returns the String
     */
    @JsonGetter("locale")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getLocale() {
        return locale;
    }

    /**
     * Setter for Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag
     * is made up of the [ISO 639-2 language
     * code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924
     * script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2
     * country code](/api/rest/reference/country-codes/) or [M49 region
     * code](https://unstats.un.org/unsd/methodology/m49/).
     * @param locale Value for String
     */
    @JsonSetter("locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    /**
     * Getter for ShippingPreference.
     * The location from which the shipping address is derived.
     * @return Returns the PaypalWalletContextShippingPreference
     */
    @JsonGetter("shipping_preference")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalWalletContextShippingPreference getShippingPreference() {
        return shippingPreference;
    }

    /**
     * Setter for ShippingPreference.
     * The location from which the shipping address is derived.
     * @param shippingPreference Value for PaypalWalletContextShippingPreference
     */
    @JsonSetter("shipping_preference")
    public void setShippingPreference(PaypalWalletContextShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    /**
     * Getter for ContactPreference.
     * The preference to display the contact information (buyer’s shipping email &amp; phone number) on
     * PayPal's checkout for easy merchant-buyer communication.
     * @return Returns the PaypalWalletContactPreference
     */
    @JsonGetter("contact_preference")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalWalletContactPreference getContactPreference() {
        return contactPreference;
    }

    /**
     * Setter for ContactPreference.
     * The preference to display the contact information (buyer’s shipping email &amp; phone number) on
     * PayPal's checkout for easy merchant-buyer communication.
     * @param contactPreference Value for PaypalWalletContactPreference
     */
    @JsonSetter("contact_preference")
    public void setContactPreference(PaypalWalletContactPreference contactPreference) {
        this.contactPreference = contactPreference;
    }

    /**
     * Getter for ReturnUrl.
     * Describes the URL.
     * @return Returns the String
     */
    @JsonGetter("return_url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getReturnUrl() {
        return returnUrl;
    }

    /**
     * Setter for ReturnUrl.
     * Describes the URL.
     * @param returnUrl Value for String
     */
    @JsonSetter("return_url")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    /**
     * Getter for CancelUrl.
     * Describes the URL.
     * @return Returns the String
     */
    @JsonGetter("cancel_url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCancelUrl() {
        return cancelUrl;
    }

    /**
     * Setter for CancelUrl.
     * Describes the URL.
     * @param cancelUrl Value for String
     */
    @JsonSetter("cancel_url")
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    /**
     * Getter for LandingPage.
     * The type of landing page to show on the PayPal site for customer checkout.
     * @return Returns the PaypalExperienceLandingPage
     */
    @JsonGetter("landing_page")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalExperienceLandingPage getLandingPage() {
        return landingPage;
    }

    /**
     * Setter for LandingPage.
     * The type of landing page to show on the PayPal site for customer checkout.
     * @param landingPage Value for PaypalExperienceLandingPage
     */
    @JsonSetter("landing_page")
    public void setLandingPage(PaypalExperienceLandingPage landingPage) {
        this.landingPage = landingPage;
    }

    /**
     * Getter for UserAction.
     * Configures a Continue or Pay Now checkout flow.
     * @return Returns the PaypalExperienceUserAction
     */
    @JsonGetter("user_action")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalExperienceUserAction getUserAction() {
        return userAction;
    }

    /**
     * Setter for UserAction.
     * Configures a Continue or Pay Now checkout flow.
     * @param userAction Value for PaypalExperienceUserAction
     */
    @JsonSetter("user_action")
    public void setUserAction(PaypalExperienceUserAction userAction) {
        this.userAction = userAction;
    }

    /**
     * Getter for PaymentMethodPreference.
     * The merchant-preferred payment methods.
     * @return Returns the PayeePaymentMethodPreference
     */
    @JsonGetter("payment_method_preference")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PayeePaymentMethodPreference getPaymentMethodPreference() {
        return paymentMethodPreference;
    }

    /**
     * Setter for PaymentMethodPreference.
     * The merchant-preferred payment methods.
     * @param paymentMethodPreference Value for PayeePaymentMethodPreference
     */
    @JsonSetter("payment_method_preference")
    public void setPaymentMethodPreference(PayeePaymentMethodPreference paymentMethodPreference) {
        this.paymentMethodPreference = paymentMethodPreference;
    }

    /**
     * Getter for OrderUpdateCallbackConfig.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     * @return Returns the CallbackConfiguration
     */
    @JsonGetter("order_update_callback_config")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CallbackConfiguration getOrderUpdateCallbackConfig() {
        return orderUpdateCallbackConfig;
    }

    /**
     * Setter for OrderUpdateCallbackConfig.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     * @param orderUpdateCallbackConfig Value for CallbackConfiguration
     */
    @JsonSetter("order_update_callback_config")
    public void setOrderUpdateCallbackConfig(CallbackConfiguration orderUpdateCallbackConfig) {
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    /**
     * Converts this PaypalWalletExperienceContext into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PaypalWalletExperienceContext [" + "brandName=" + brandName + ", locale=" + locale
                + ", shippingPreference=" + shippingPreference + ", contactPreference="
                + contactPreference + ", returnUrl=" + returnUrl + ", cancelUrl=" + cancelUrl
                + ", landingPage=" + landingPage + ", userAction=" + userAction
                + ", paymentMethodPreference=" + paymentMethodPreference
                + ", orderUpdateCallbackConfig=" + orderUpdateCallbackConfig + "]";
    }

    /**
     * Builds a new {@link PaypalWalletExperienceContext.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PaypalWalletExperienceContext.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .brandName(getBrandName())
                .locale(getLocale())
                .shippingPreference(getShippingPreference())
                .contactPreference(getContactPreference())
                .returnUrl(getReturnUrl())
                .cancelUrl(getCancelUrl())
                .landingPage(getLandingPage())
                .userAction(getUserAction())
                .paymentMethodPreference(getPaymentMethodPreference())
                .orderUpdateCallbackConfig(getOrderUpdateCallbackConfig());
        return builder;
    }

    /**
     * Class to build instances of {@link PaypalWalletExperienceContext}.
     */
    public static class Builder {
        private String brandName;
        private String locale;
        private PaypalWalletContextShippingPreference shippingPreference =
                PaypalWalletContextShippingPreference.GET_FROM_FILE;
        private PaypalWalletContactPreference contactPreference =
                PaypalWalletContactPreference.NO_CONTACT_INFO;
        private String returnUrl;
        private String cancelUrl;
        private PaypalExperienceLandingPage landingPage = PaypalExperienceLandingPage.NO_PREFERENCE;
        private PaypalExperienceUserAction userAction = PaypalExperienceUserAction.CONTINUE;
        private PayeePaymentMethodPreference paymentMethodPreference =
                PayeePaymentMethodPreference.UNRESTRICTED;
        private CallbackConfiguration orderUpdateCallbackConfig;



        /**
         * Setter for brandName.
         * @param  brandName  String value for brandName.
         * @return Builder
         */
        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        /**
         * Setter for locale.
         * @param  locale  String value for locale.
         * @return Builder
         */
        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Setter for shippingPreference.
         * @param  shippingPreference  PaypalWalletContextShippingPreference value for
         *         shippingPreference.
         * @return Builder
         */
        public Builder shippingPreference(
                PaypalWalletContextShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        /**
         * Setter for contactPreference.
         * @param  contactPreference  PaypalWalletContactPreference value for contactPreference.
         * @return Builder
         */
        public Builder contactPreference(PaypalWalletContactPreference contactPreference) {
            this.contactPreference = contactPreference;
            return this;
        }

        /**
         * Setter for returnUrl.
         * @param  returnUrl  String value for returnUrl.
         * @return Builder
         */
        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        /**
         * Setter for cancelUrl.
         * @param  cancelUrl  String value for cancelUrl.
         * @return Builder
         */
        public Builder cancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        /**
         * Setter for landingPage.
         * @param  landingPage  PaypalExperienceLandingPage value for landingPage.
         * @return Builder
         */
        public Builder landingPage(PaypalExperienceLandingPage landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        /**
         * Setter for userAction.
         * @param  userAction  PaypalExperienceUserAction value for userAction.
         * @return Builder
         */
        public Builder userAction(PaypalExperienceUserAction userAction) {
            this.userAction = userAction;
            return this;
        }

        /**
         * Setter for paymentMethodPreference.
         * @param  paymentMethodPreference  PayeePaymentMethodPreference value for
         *         paymentMethodPreference.
         * @return Builder
         */
        public Builder paymentMethodPreference(
                PayeePaymentMethodPreference paymentMethodPreference) {
            this.paymentMethodPreference = paymentMethodPreference;
            return this;
        }

        /**
         * Setter for orderUpdateCallbackConfig.
         * @param  orderUpdateCallbackConfig  CallbackConfiguration value for
         *         orderUpdateCallbackConfig.
         * @return Builder
         */
        public Builder orderUpdateCallbackConfig(
                CallbackConfiguration orderUpdateCallbackConfig) {
            this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
            return this;
        }

        /**
         * Builds a new {@link PaypalWalletExperienceContext} object using the set fields.
         * @return {@link PaypalWalletExperienceContext}
         */
        public PaypalWalletExperienceContext build() {
            return new PaypalWalletExperienceContext(brandName, locale, shippingPreference,
                    contactPreference, returnUrl, cancelUrl, landingPage, userAction,
                    paymentMethodPreference, orderUpdateCallbackConfig);
        }
    }
}
