/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for SellerReceivableBreakdown type.
 */
public class SellerReceivableBreakdown {
    private Money grossAmount;
    private Money paypalFee;
    private Money paypalFeeInReceivableCurrency;
    private Money netAmount;
    private Money receivableAmount;
    private ExchangeRate exchangeRate;
    private List<PlatformFee> platformFees;

    /**
     * Default constructor.
     */
    public SellerReceivableBreakdown() {
    }

    /**
     * Initialization constructor.
     * @param  grossAmount  Money value for grossAmount.
     * @param  paypalFee  Money value for paypalFee.
     * @param  paypalFeeInReceivableCurrency  Money value for paypalFeeInReceivableCurrency.
     * @param  netAmount  Money value for netAmount.
     * @param  receivableAmount  Money value for receivableAmount.
     * @param  exchangeRate  ExchangeRate value for exchangeRate.
     * @param  platformFees  List of PlatformFee value for platformFees.
     */
    public SellerReceivableBreakdown(
            Money grossAmount,
            Money paypalFee,
            Money paypalFeeInReceivableCurrency,
            Money netAmount,
            Money receivableAmount,
            ExchangeRate exchangeRate,
            List<PlatformFee> platformFees) {
        this.grossAmount = grossAmount;
        this.paypalFee = paypalFee;
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
        this.netAmount = netAmount;
        this.receivableAmount = receivableAmount;
        this.exchangeRate = exchangeRate;
        this.platformFees = platformFees;
    }

    /**
     * Getter for GrossAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("gross_amount")
    public Money getGrossAmount() {
        return grossAmount;
    }

    /**
     * Setter for GrossAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param grossAmount Value for Money
     */
    @JsonSetter("gross_amount")
    public void setGrossAmount(Money grossAmount) {
        this.grossAmount = grossAmount;
    }

    /**
     * Getter for PaypalFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("paypal_fee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getPaypalFee() {
        return paypalFee;
    }

    /**
     * Setter for PaypalFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param paypalFee Value for Money
     */
    @JsonSetter("paypal_fee")
    public void setPaypalFee(Money paypalFee) {
        this.paypalFee = paypalFee;
    }

    /**
     * Getter for PaypalFeeInReceivableCurrency.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("paypal_fee_in_receivable_currency")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getPaypalFeeInReceivableCurrency() {
        return paypalFeeInReceivableCurrency;
    }

    /**
     * Setter for PaypalFeeInReceivableCurrency.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param paypalFeeInReceivableCurrency Value for Money
     */
    @JsonSetter("paypal_fee_in_receivable_currency")
    public void setPaypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
    }

    /**
     * Getter for NetAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("net_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getNetAmount() {
        return netAmount;
    }

    /**
     * Setter for NetAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param netAmount Value for Money
     */
    @JsonSetter("net_amount")
    public void setNetAmount(Money netAmount) {
        this.netAmount = netAmount;
    }

    /**
     * Getter for ReceivableAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("receivable_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getReceivableAmount() {
        return receivableAmount;
    }

    /**
     * Setter for ReceivableAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param receivableAmount Value for Money
     */
    @JsonSetter("receivable_amount")
    public void setReceivableAmount(Money receivableAmount) {
        this.receivableAmount = receivableAmount;
    }

    /**
     * Getter for ExchangeRate.
     * The exchange rate that determines the amount to convert from one currency to another
     * currency.
     * @return Returns the ExchangeRate
     */
    @JsonGetter("exchange_rate")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ExchangeRate getExchangeRate() {
        return exchangeRate;
    }

    /**
     * Setter for ExchangeRate.
     * The exchange rate that determines the amount to convert from one currency to another
     * currency.
     * @param exchangeRate Value for ExchangeRate
     */
    @JsonSetter("exchange_rate")
    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /**
     * Getter for PlatformFees.
     * An array of platform or partner fees, commissions, or brokerage fees that associated with the
     * captured payment.
     * @return Returns the List of PlatformFee
     */
    @JsonGetter("platform_fees")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<PlatformFee> getPlatformFees() {
        return platformFees;
    }

    /**
     * Setter for PlatformFees.
     * An array of platform or partner fees, commissions, or brokerage fees that associated with the
     * captured payment.
     * @param platformFees Value for List of PlatformFee
     */
    @JsonSetter("platform_fees")
    public void setPlatformFees(List<PlatformFee> platformFees) {
        this.platformFees = platformFees;
    }

    /**
     * Converts this SellerReceivableBreakdown into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "SellerReceivableBreakdown [" + "grossAmount=" + grossAmount + ", paypalFee="
                + paypalFee + ", paypalFeeInReceivableCurrency=" + paypalFeeInReceivableCurrency
                + ", netAmount=" + netAmount + ", receivableAmount=" + receivableAmount
                + ", exchangeRate=" + exchangeRate + ", platformFees=" + platformFees + "]";
    }

    /**
     * Builds a new {@link SellerReceivableBreakdown.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link SellerReceivableBreakdown.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(grossAmount)
                .paypalFee(getPaypalFee())
                .paypalFeeInReceivableCurrency(getPaypalFeeInReceivableCurrency())
                .netAmount(getNetAmount())
                .receivableAmount(getReceivableAmount())
                .exchangeRate(getExchangeRate())
                .platformFees(getPlatformFees());
        return builder;
    }

    /**
     * Class to build instances of {@link SellerReceivableBreakdown}.
     */
    public static class Builder {
        private Money grossAmount;
        private Money paypalFee;
        private Money paypalFeeInReceivableCurrency;
        private Money netAmount;
        private Money receivableAmount;
        private ExchangeRate exchangeRate;
        private List<PlatformFee> platformFees;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  grossAmount  Money value for grossAmount.
         */
        public Builder(Money grossAmount) {
            this.grossAmount = grossAmount;
        }

        /**
         * Setter for grossAmount.
         * @param  grossAmount  Money value for grossAmount.
         * @return Builder
         */
        public Builder grossAmount(Money grossAmount) {
            this.grossAmount = grossAmount;
            return this;
        }

        /**
         * Setter for paypalFee.
         * @param  paypalFee  Money value for paypalFee.
         * @return Builder
         */
        public Builder paypalFee(Money paypalFee) {
            this.paypalFee = paypalFee;
            return this;
        }

        /**
         * Setter for paypalFeeInReceivableCurrency.
         * @param  paypalFeeInReceivableCurrency  Money value for paypalFeeInReceivableCurrency.
         * @return Builder
         */
        public Builder paypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
            this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
            return this;
        }

        /**
         * Setter for netAmount.
         * @param  netAmount  Money value for netAmount.
         * @return Builder
         */
        public Builder netAmount(Money netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        /**
         * Setter for receivableAmount.
         * @param  receivableAmount  Money value for receivableAmount.
         * @return Builder
         */
        public Builder receivableAmount(Money receivableAmount) {
            this.receivableAmount = receivableAmount;
            return this;
        }

        /**
         * Setter for exchangeRate.
         * @param  exchangeRate  ExchangeRate value for exchangeRate.
         * @return Builder
         */
        public Builder exchangeRate(ExchangeRate exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        /**
         * Setter for platformFees.
         * @param  platformFees  List of PlatformFee value for platformFees.
         * @return Builder
         */
        public Builder platformFees(List<PlatformFee> platformFees) {
            this.platformFees = platformFees;
            return this;
        }

        /**
         * Builds a new {@link SellerReceivableBreakdown} object using the set fields.
         * @return {@link SellerReceivableBreakdown}
         */
        public SellerReceivableBreakdown build() {
            return new SellerReceivableBreakdown(grossAmount, paypalFee,
                    paypalFeeInReceivableCurrency, netAmount, receivableAmount, exchangeRate,
                    platformFees);
        }
    }
}
