/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for SetupTokenResponse type.
 */
public class SetupTokenResponse {
    private String id;
    private Customer customer;
    private PaymentTokenStatus status;
    private SetupTokenResponsePaymentSource paymentSource;
    private List<LinkDescription> links;

    /**
     * Default constructor.
     */
    public SetupTokenResponse() {
        status = PaymentTokenStatus.CREATED;
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  customer  Customer value for customer.
     * @param  status  PaymentTokenStatus value for status.
     * @param  paymentSource  SetupTokenResponsePaymentSource value for paymentSource.
     * @param  links  List of LinkDescription value for links.
     */
    public SetupTokenResponse(
            String id,
            Customer customer,
            PaymentTokenStatus status,
            SetupTokenResponsePaymentSource paymentSource,
            List<LinkDescription> links) {
        this.id = id;
        this.customer = customer;
        this.status = status;
        this.paymentSource = paymentSource;
        this.links = links;
    }

    /**
     * Getter for Id.
     * The PayPal-generated ID for the vault token.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The PayPal-generated ID for the vault token.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save
     * payment methods and contact details.
     * @return Returns the Customer
     */
    @JsonGetter("customer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Customer getCustomer() {
        return customer;
    }

    /**
     * Setter for Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save
     * payment methods and contact details.
     * @param customer Value for Customer
     */
    @JsonSetter("customer")
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    /**
     * Getter for Status.
     * The status of the payment token.
     * @return Returns the PaymentTokenStatus
     */
    @JsonGetter("status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaymentTokenStatus getStatus() {
        return status;
    }

    /**
     * Setter for Status.
     * The status of the payment token.
     * @param status Value for PaymentTokenStatus
     */
    @JsonSetter("status")
    public void setStatus(PaymentTokenStatus status) {
        this.status = status;
    }

    /**
     * Getter for PaymentSource.
     * The setup payment method details.
     * @return Returns the SetupTokenResponsePaymentSource
     */
    @JsonGetter("payment_source")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public SetupTokenResponsePaymentSource getPaymentSource() {
        return paymentSource;
    }

    /**
     * Setter for PaymentSource.
     * The setup payment method details.
     * @param paymentSource Value for SetupTokenResponsePaymentSource
     */
    @JsonSetter("payment_source")
    public void setPaymentSource(SetupTokenResponsePaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    /**
     * Getter for Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     * @return Returns the List of LinkDescription
     */
    @JsonGetter("links")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<LinkDescription> getLinks() {
        return links;
    }

    /**
     * Setter for Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     * @param links Value for List of LinkDescription
     */
    @JsonSetter("links")
    public void setLinks(List<LinkDescription> links) {
        this.links = links;
    }

    /**
     * Converts this SetupTokenResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "SetupTokenResponse [" + "id=" + id + ", customer=" + customer + ", status=" + status
                + ", paymentSource=" + paymentSource + ", links=" + links + "]";
    }

    /**
     * Builds a new {@link SetupTokenResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link SetupTokenResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .customer(getCustomer())
                .status(getStatus())
                .paymentSource(getPaymentSource())
                .links(getLinks());
        return builder;
    }

    /**
     * Class to build instances of {@link SetupTokenResponse}.
     */
    public static class Builder {
        private String id;
        private Customer customer;
        private PaymentTokenStatus status = PaymentTokenStatus.CREATED;
        private SetupTokenResponsePaymentSource paymentSource;
        private List<LinkDescription> links;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for customer.
         * @param  customer  Customer value for customer.
         * @return Builder
         */
        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        /**
         * Setter for status.
         * @param  status  PaymentTokenStatus value for status.
         * @return Builder
         */
        public Builder status(PaymentTokenStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Setter for paymentSource.
         * @param  paymentSource  SetupTokenResponsePaymentSource value for paymentSource.
         * @return Builder
         */
        public Builder paymentSource(SetupTokenResponsePaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        /**
         * Setter for links.
         * @param  links  List of LinkDescription value for links.
         * @return Builder
         */
        public Builder links(List<LinkDescription> links) {
            this.links = links;
            return this;
        }

        /**
         * Builds a new {@link SetupTokenResponse} object using the set fields.
         * @return {@link SetupTokenResponse}
         */
        public SetupTokenResponse build() {
            return new SetupTokenResponse(id, customer, status, paymentSource, links);
        }
    }
}
