/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for TrustlyPaymentObject type.
 */
public class TrustlyPaymentObject {
    private String name;
    private String countryCode;
    private String email;
    private String bic;
    private String ibanLastChars;

    /**
     * Default constructor.
     */
    public TrustlyPaymentObject() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  countryCode  String value for countryCode.
     * @param  email  String value for email.
     * @param  bic  String value for bic.
     * @param  ibanLastChars  String value for ibanLastChars.
     */
    public TrustlyPaymentObject(
            String name,
            String countryCode,
            String email,
            String bic,
            String ibanLastChars) {
        this.name = name;
        this.countryCode = countryCode;
        this.email = email;
        this.bic = bic;
        this.ibanLastChars = ibanLastChars;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Getter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmail() {
        return email;
    }

    /**
     * Setter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param email Value for String
     */
    @JsonSetter("email")
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Getter for Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a
     * specific business, most commonly a bank.
     * @return Returns the String
     */
    @JsonGetter("bic")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBic() {
        return bic;
    }

    /**
     * Setter for Bic.
     * The business identification code (BIC). In payments systems, a BIC is used to identify a
     * specific business, most commonly a bank.
     * @param bic Value for String
     */
    @JsonSetter("bic")
    public void setBic(String bic) {
        this.bic = bic;
    }

    /**
     * Getter for IbanLastChars.
     * The last characters of the IBAN used to pay.
     * @return Returns the String
     */
    @JsonGetter("iban_last_chars")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getIbanLastChars() {
        return ibanLastChars;
    }

    /**
     * Setter for IbanLastChars.
     * The last characters of the IBAN used to pay.
     * @param ibanLastChars Value for String
     */
    @JsonSetter("iban_last_chars")
    public void setIbanLastChars(String ibanLastChars) {
        this.ibanLastChars = ibanLastChars;
    }

    /**
     * Converts this TrustlyPaymentObject into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "TrustlyPaymentObject [" + "name=" + name + ", countryCode=" + countryCode
                + ", email=" + email + ", bic=" + bic + ", ibanLastChars=" + ibanLastChars + "]";
    }

    /**
     * Builds a new {@link TrustlyPaymentObject.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link TrustlyPaymentObject.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .countryCode(getCountryCode())
                .email(getEmail())
                .bic(getBic())
                .ibanLastChars(getIbanLastChars());
        return builder;
    }

    /**
     * Class to build instances of {@link TrustlyPaymentObject}.
     */
    public static class Builder {
        private String name;
        private String countryCode;
        private String email;
        private String bic;
        private String ibanLastChars;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for email.
         * @param  email  String value for email.
         * @return Builder
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        /**
         * Setter for bic.
         * @param  bic  String value for bic.
         * @return Builder
         */
        public Builder bic(String bic) {
            this.bic = bic;
            return this;
        }

        /**
         * Setter for ibanLastChars.
         * @param  ibanLastChars  String value for ibanLastChars.
         * @return Builder
         */
        public Builder ibanLastChars(String ibanLastChars) {
            this.ibanLastChars = ibanLastChars;
            return this;
        }

        /**
         * Builds a new {@link TrustlyPaymentObject} object using the set fields.
         * @return {@link TrustlyPaymentObject}
         */
        public TrustlyPaymentObject build() {
            return new TrustlyPaymentObject(name, countryCode, email, bic, ibanLastChars);
        }
    }
}
